#!/usr/bin/python
# Copyright (c) 2010 Alon Swartz <alon@turnkeylinux.org> - all rights reserved
"""Set account password

Arguments:
    username      username of account to set password for

Options:
    -p --pass=    if not provided, will ask interactively
"""

import sys
import getopt
from executil import system
from dialog_wrapper import Dialog

def usage(s=None):
    if s:
        print >> sys.stderr, "Error:", s
    print >> sys.stderr, "Syntax: %s <username> [options]" % sys.argv[0]
    print >> sys.stderr, __doc__
    sys.exit(1)

def escape_chars(s):
    """escape special characters"""
    s = s.replace("\\", "\\\\")  # \
    s = s.replace('"', '\\"')    # "
    s = s.replace("'", "'\\''")  # '
    s = s.replace("`", "\\`")    # `
    return s

def main():
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "hp:", ['help', 'pass='])
    except getopt.GetoptError, e:
        usage(e)

    if len(args) != 1:
        usage()

    username = args[0]
    password = ""
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt in ('-p', '--pass'):
            password = val
            if password:
                fo=open("/var/www/phpvirtualbox/config.php-example","r")
                info=str(file.read(fo))
                conf=str.replace(info,"-pass-",password)
                fo.close
                fo=open("/var/www/phpvirtualbox/config.php","w")
                conf=str(conf)
                fo.write(conf)
                fo.close
                
    if not password:
        d = Dialog('TurnKey Linux - First boot configuration')
        password = d.get_password(
            "%s Password" % username.capitalize(),
            "Please enter new password for the %s account." % username)
        if password:
            fo=open("/var/www/vb/config.php-example","r")
            info=str(file.read(fo))
            conf=str.replace(info,"-pass-",password)
            fo.close
            fo=open("/var/www/vb/config.php","w")
            conf=str(conf)
            fo.write(conf)
            fo.close
    # ugly hack to support lenny
    import lsb_release
    codename = lsb_release.get_distro_information()['CODENAME']

    if codename == 'lenny':
        system("echo %s:%s | chpasswd -m" % (username, escape_chars(password)))
    else:
        system("echo %s:%s | chpasswd" % (username, escape_chars(password)))

if __name__ == "__main__":
    main()

