module("BacklogController", {
	setup: function() {
		addBacklogAndTestDataCreationMethods(this);
		$('#test-container').append('<div class="main" id="backlog"/>');
	},
	teardown: function() {
		BacklogController.callbacksForDidLoad = [];
		BacklogController.callbacksForAfterRendering = [];
		$('#test-container')[0].innerHTML = '';
	}
});

test("gets error message when an error happen during loading with BacklogServerCommunicator", function() {
	expect(1);
	var controller = new BacklogController();
	controller.view.setMessage = function(errorMessage) {
		equals('fnord', errorMessage);
	};
	controller.model.loader.showError('fnord');
});

test("can register for callback after backlog loading", function() {
	var firstSensedController = null;
	BacklogController.registerForCallbackAfterLoad(function(controller){
		firstSensedController = controller;
	});
	var secondSensedController = null;
	BacklogController.registerForCallbackAfterLoad(function(controller){
		secondSensedController = controller;
	});
	equals(firstSensedController, null);
	equals(secondSensedController, null);
	
	var controller = new BacklogController();
	controller.didLoadBacklog();
	equals(firstSensedController, controller);
	equals(secondSensedController, controller);
});

test("does callbacks after loading but before rendering", function() {
	expect(1);
	var controller = new BacklogController();
	var didCallAfterLoad = false;
	BacklogController.registerForCallbackAfterLoad(function(){
		didCallAfterLoad = true;
	});
	controller.renderBacklog = function() {
		ok(didCallAfterLoad);
	};
	controller.model.loader.stubEverything();
	controller.loadBacklog();
});


test("can register for callback after backlog loading", function() {
	var firstSensedController = null;
	BacklogController.registerForCallbackAfterRendering(function(controller){
		firstSensedController = controller;
	});
	var secondSensedController = null;
	BacklogController.registerForCallbackAfterRendering(function(controller){
		secondSensedController = controller;
	});
	equals(firstSensedController, null);
	equals(secondSensedController, null);
	
	var controller = new BacklogController();
	controller.didRenderBacklog();
	equals(firstSensedController, controller);
	equals(secondSensedController, controller);
});

test("does callbacks after rendering", function() {
	expect(1);
	var controller = new BacklogController();
	var didCallAfterRender = false;
	BacklogController.registerForCallbackAfterLoad(function(){
		didCallAfterRender = true;
	});
	BacklogController.registerForCallbackAfterRendering(function(){
		ok(didCallAfterRender);
	});
	controller.model.loader.stubEverything();
	controller.loadBacklog();
});

test("can add task from json and render it immediately", function() {
	var controller = new BacklogController();
	controller.model = this.backlog;
	this.injectUserStory(1);
	controller.renderBacklog();
	var json = this.buildJSON(2, 'task');
	json.incoming_links = [1];
	equals(controller.model.tickets().length, 1);
	var ticket = controller.addTicketFromJSON(json);
	equals(controller.view.firstViewForTicket(ticket).dom().length, 1);
	equals(controller.model.tickets().length, 2);
});

test("updates positions after adding a new task", function() {
	expect(1);
	var controller = new BacklogController();
	controller.model = this.backlog;
	this.injectUserStory(1);
	controller.renderBacklog();
	var json = this.buildJSON(2, 'task');
	json.incoming_links = [1];
	
	controller.positionsDidChange = function() { ok('true'); };
	controller.addTicketFromJSON(json);
});

test("can update ticket in model and view from json", function() {
	var controller = new BacklogController();
	controller.model = this.backlog;
	var story = this.injectUserStory(1);
	controller.renderBacklog();
	var json = this.buildJSON(1, 'story');
	json.summary = 'fnord';
	
	var storyView = controller.view.firstViewForTicket(story);
	equals(storyView.dom('.summary').text(), 'story #1');
	equals(story.json.summary, 'story #1');
	
	var ticket = controller.model.updateTicketFromJSON(json);
	ok(story === ticket);
	equals(story.json.summary, 'fnord');
	equals(storyView.dom('.summary').text(), 'fnord');
});

// REFACT: move the backlogcontroller to the setup...