# -*- encoding: utf-8 -*-
#   Copyright 2010 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

from trac.util.datefmt import format_date

from agilo.scrum.sprint import Sprint, SprintAdminPanel
from agilo.test import AgiloTestCase
from agilo.utils.days_time import now


class SprintAdminPanelTest(AgiloTestCase):
    
    def test_do_not_create_sprint_without_start_date(self):
        panel = SprintAdminPanel(self.env)
        req = self.teh.mock_request()
        req.args = dict(name='fnord', add=True)
        panel.list_save_view(req, 'agilo', 'sprints')
        self.assert_false(Sprint(self.env, name='fnord').exists)
    
    def test_do_not_create_sprints_with_slashes_in_name(self):
        panel = SprintAdminPanel(self.env)
        req = self.teh.mock_request()
        req.args = dict(name='a/b', start=format_date(now()), duration=10, add=True)
        panel.list_save_view(req, 'agilo', 'sprints')
        self.assert_false(Sprint(self.env, name='a/b').exists)
    
    def test_can_not_edit_sprint_name_so_it_contains_a_slash(self):
        panel = SprintAdminPanel(self.env)
        sprint = self.teh.create_sprint('fnord')
        req = self.teh.mock_request()
        req.args = dict(name='a/b')
        panel.detail_save_view(req, 'agilo', 'sprints', sprint.name)
        self.assert_false(Sprint(self.env, name='a/b').exists)

