# -*- encoding: utf-8 -*-

__all__ = ['AgiloTestCase', 'JSONAgiloTestCase']

import agilo.utils.filterwarnings

from datetime import timedelta

from agilo.api import ValueObject
from agilo.test.pythonic_testcase import PythonicTestCase
from agilo.test.test_env_helper import TestEnvHelper
from agilo.ticket.api import AgiloTicketSystem

from trac.web.api import RequestDone

class AgiloTestCase(PythonicTestCase):
    
    testtype = 'unittest'
    is_abstract_test = True
    
    def setUp(self):
        self.super()
        self.teh = TestEnvHelper()
        self.env = self.teh.get_env()
        self.teh.clear_ticket_system_field_cache()
    
    def sprint_name(self):
        return self.__class__.__name__ + 'Sprint'
    
    def assert_time_equals(self, expected, actual, max_delta=timedelta(seconds=2), msg=None):
        self.assert_almost_equals(expected, actual, max_delta=max_delta, msg=msg)
    

class JSONAgiloTestCase(AgiloTestCase):
    is_abstract_test = True

    def assert_method_returns_error_with_empty_data(self, *args, **kwargs):
        response = self.assert_method_returns_error(*args, **kwargs)
        self.assert_equals({}, response.current_data)
        return response
    
    def assert_method_returns_error(self, method, req, *args, **kwargs):
        self.assert_raises(RequestDone, method, req, *args, **kwargs)
        response = ValueObject(req.response.body_as_json())
        self.assert_equals(1, len(response.errors))
        return response

