# -*- encoding: utf-8 -*-
#   Copyright 2008 Agile42 GmbH, Berlin (Germany)
#   Copyright 2007 Andrea Tomasini <andrea.tomasini_at_agile42.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Jonas von Poser <jonas.vonposer__at__agile42.com>
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

from trac.tests.functional import tc

from agilo.test import Usernames
from agilo.test.functional import AgiloFunctionalTestCase


class TestAdminLinks(AgiloFunctionalTestCase):
    
    def runTest(self):
        self._tester.login_as(Usernames.admin)
        # get list page to add new link
        page_url = self._tester.url + '/admin/agilo/links'
        tc.go(page_url)
        tc.url(page_url)
        tc.code(200)
        # see if one of the default links is there
        tc.find('story-task">Task</a>')
        
        # check if the alias module works correctly, reload the page
        tc.go(page_url)
        tc.find('story-task">Task</a>')
        
        # add new link
        # this form uses the aliased values
        tc.formvalue('addlink', 'source', 'Bug')
        tc.formvalue('addlink', 'target', 'Requirement')
        tc.submit('add')
        # save should redirect to edit page, see if it does
        tc.find('Modify Bug-Requirement Link')
        
        # add new link
        tc.formvalue('modcomp', 'copy_fields', '+resolution')
        tc.submit('save')
        
        # redirects to list page, now new link should be found
        tc.find('bug-requirement')


if __name__ == '__main__':
    from agilo.test.testfinder import run_all_tests
    run_all_tests(__file__)

