#!/usr/bin/env python
# -*- coding: utf-8 -*-
#   Copyright 2008 Agile42 GmbH - Andrea Tomasini 
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
# 
# Authors:
#     - Andrea Tomasini <andrea.tomasini_at_agile42.com>
#     - Felix Schwarz <felix.schwarz_at_agile42.com>


from agilo.test import AgiloTestCase
from agilo.utils.config import AgiloConfig


class InstallationTest(AgiloTestCase):
    """Tests agilo installation process, calling the main init method"""
    
    def setUp(self):
        self.super()
        self.env = self.initialize_and_upgrade_agilo()
        self.config = AgiloConfig(self.env)
    
    def initialize_and_upgrade_agilo(self, enabled_third_party_components=()):
        env = self.teh._create_stub_environment(enabled_third_party_components, False, True)
        self.teh._upgrade_environment(env)
        return env
    
    def test_initialization_adds_agilo_policy(self):
        self.assert_equals(self.config.get('permission_policies', section='trac'),
                          u'AgiloPolicy, DefaultPermissionPolicy, LegacyAttachmentPolicy')
    
    def test_initialization_set_templates_dir(self):
        template_path = self.config.get('templates_dir', section='inherit')
        self.assert_true(template_path.find('templates') > -1)
    
    def is_email_verification_enabled(self, env):
        AgiloConfig(env).clear_trac_component_cache()
        try:
            from acct_mgr.web_ui import EmailVerificationModule
            return env.is_component_enabled(EmailVerificationModule)
        except ImportError:
            return None
    
    def assert_status_of_email_verification_module(self, env, expected):
        is_enabled = self.is_email_verification_enabled(env)
        if is_enabled is None:
            return
        self.assert_equals(expected, is_enabled)
    
    def test_email_verification_module_is_disabled_after_initialization(self):
        env = self.initialize_and_upgrade_agilo(['acct_mgr.*'])
        self.assert_status_of_email_verification_module(env, False)
    
    def test_email_verification_stays_enabled_if_enabled_explicitely_before(self):
        env = self.initialize_and_upgrade_agilo(['acct_mgr.*', 'acct_mgr.web_ui.emailverificationmodule'])
        self.assert_status_of_email_verification_module(env, True)


if __name__ == '__main__':
    from agilo.test.testfinder import run_unit_tests
    run_unit_tests(__file__)