##<?php exit(); ?>##
####################
# General Config   #
####################

# This value is used to detect quickly
# if this config file is up to date 
# this is compared against a value hardcoded
# into the init script
config_version = 3

####################
# Path Vars        #
####################

# The path to your ampache install
# Do not put a trailing / on this path 
# For example if your site is located at http://localhost
# than you do not need to enter anything for the web_path
# if it is located at http://localhost/music you need to 
# set web_path to /music
# DEFAULT: ""
web_path = ""

###############################
# Session and Login Variables #
###############################

# Hostname of your Database
# DEFAULT: localhost
local_host = "localhost"

# Name of your ampache database
# DEFAULT: ampache
local_db = "ampache"

# Username for your ampache database
# DEFAULT: ""
local_username = "ampache"

# Password for your ampache database, this can not be blank
# this is a 'forced' security precaution, the default value
# will not work
# DEFAULT: ""
local_pass = "ampache"

# Length that a session will last, the default is very restrictive
# at 15min
# DEFAULT: 900
local_length = 900

# This length defines how long a 'remember me' session and cookie will 
# last, the default is 1800, same as length. It is up to the administrator
# of the box to increase this, for reference 86400 = 1 day 
# 604800 = 1 week and 2419200 = 1 month
# DEAFULT: 1800
remember_length = 1800

# Name of the Session/Cookie that will sent to the browser
# default should be fine
# DEFAULT: ampache
sess_name               = ampache

# Lifetime of the Cookie, 0 == Forever (until browser close) , otherwise in terms of seconds
# DEFAULT: 0
sess_cookielife         = 0

# Is the cookie a "secure" cookie?
# DEFAULT: 0
sess_cookiesecure       = 0

# Auth Methods 
# This defines which auth methods vauth will attempt
# to use and in which order, if auto_create isn't enabled
# The user must exist locally as well
# DEFAULT: mysql
# VALUES: mysql,ldap,http
#auth_methods = "ldap"
auth_methods = "mysql"

######################
#  Program Settings  #
######################

# File Pattern
# This defines which file types Ampache will attempt to catalog
# You can specify any file extension you want in here seperating them
# with a |
# DEFAULT: mp3|mpc|m4p|m4a|mp4|aac|ogg|rm|wma|asf|flac|spx|ra|ape|shn|wv
catalog_file_pattern = "mp3|mpc|m4p|m4a|mp4|aac|ogg|rm|wma|asf|flac|spx|ra|ape|shn|wv"

# Use Access List 
# Toggle this on if you want ampache to pay attention to the access list
# and only allow streaming/downloading/xml-rpc from known hosts by default
# xml-rpc will not working without this on.
# DEFAULT: false
#access_control	= "false"

# Require Session
# If this is set to true ampache will make sure that the URL passed when
# attempting to retrieve a song contains a valid Session ID This prevents
# others from guessing URL's
# DEFAULT: true
require_session = "true"

# Multiple Logins
# Added by Vlet 07/25/07
# When this setting is enabled a user may only be logged in from a single
# IP address at any one time, this is to prevent sharing of accounts
# DEFAULT: false
#prevent_multiple_logins = "false"

# Downsample Remote
# If this is set to true and access control is on any users who are not
# coming from a defined localnet will be automatically downsampled
# regardless of their preferences
# DEFAULT: false
#downsample_remote = "false"

# Track User IPs
# If this is enabled Ampache will log the IP of every completed login
# it will store user,ip,time at one row per login. The results are 
# displayed in Admin --> Users
# DEFAULT: false
#track_user_ip = "false"

# User IP Cardinality
# This defines how many days worth of IP history Ampache will track
# As it is one row per login on high volume sites you will want to 
# clear it every now and then. 
# DEFAULT: 42 days
#user_ip_cardinality = "42"

# Use XML-RPC
# Allow XML-RPC connections, if you don't want _any_ possibility of your
# catalog being streamed from another location comment this out
# DEFAULT: false
#xml_rpc 	= "false"

# This setting allows/disallows using zlib to zip up an entire
# playlist/album for download. Even if this is turned on you will
# still need to enabled downloading for the specific user you 
# want to be able to use this function
# DEFAULT: false
#allow_zip_download = "false"

# This setting throttles a persons downloading to the specified
# bytes per second. This is not a 100% guaranteed function, and 
# you should really use a server based rate limiter if you want
# to do this correctly. 
# DEFAULT: off
# VALUES: any whole number (in bytes per second)
#throttle_download = 10

# This determines the tag order for all cataloged
# music. If none of the listed tags are found then
# ampache will default to the first tag format
# that was found. 
# POSSIBLE VALUES: id3v1 id3v2 file vorbiscomment 
#                  quicktime ape asf
# DEFAULT: id3v2,id3v1 vorbiscomment quicktime ape
# 		asf
tag_order	= id3v2
tag_order	= id3v1
tag_order	= vorbiscomment
tag_order	= quicktime
tag_order	= ape
tag_order 	= asf
#tag_order	= file

# Un comment if don't want ampache to follow symlinks
# DEFAULT: false
#no_symlinks	= "false"

# Use auth?
# If this is set to "Yes" ampache will require a valid
# Username and password. If this is set to false then ampache
# will not ask you for a username and password. false is only
# recommended for internal only instances
# DEFAULT true
use_auth	= "yes"

# 5 Star Ratings
# This allows ratings for almost any object in ampache
# POSSIBLE VALUES: false true
# DEFAULT: true
ratings = "true"

# This options will turn on/off Demo Mode
# If Demo mode is on you can not play songs or update your catalog
# in other words.. leave this commented out
# DEFAULT: false
#demo_mode = "false"

# Memory Limit
# This defines the "Min" memory limit for PHP if your php.ini
# has a lower value set Ampache will set it up to this. If you
# set it below 16MB getid3() will not work!
# DEFAULT: 24
#memory_limit = 24

# Album Art Preferred Filename
# Specify a filename to look for if you always give the same filename
# i.e. "folder.jpg" Ampache currently only supports jpg/gif and png
# Especially useful if you have a front and a back image in a folder
# comment out if ampache should search for any jpg,gif or png
# You can use % to represent a 'wildcard' in the filename for example
# a value of "%old%.jpg" would match folder.jpg, old.jpg, older.jpg 
# or any file that contains the letters "old" and ends in .jpg
# use of %'s will slow down your album art gather as it requires more
# processing
# DEFAULT: folder.jpg
#album_art_preferred_filename = "folder.jpg" 

# Resize Images * Requires PHP-GD *
# Set this to true if you want Ampache to resize the Album
# art on the fly, this increases load time and CPU usage
# and also requires the PHP-GD library. This is very useful
# If you have high-quality album art and a small upload cap
# DEFAULT: false
#resize_images = "false"

# Album Art Gather Order
# Simply arrange the following in the order you would like
# ampache to search if you want to disable one of the search
# method simply comment it out valid values are
# POSSIBLE VALUES: db id3 folder lastfm amazon
# DEFAULT: db,id3,folder,lastfm,amazon
album_art_order = "db"
album_art_order = "id3"
album_art_order = "folder"
album_art_order = "lastfm"
album_art_order = "amazon"

# Album Art 
# Set this to true if you want album art displayed on pages besides the
# Single Album view, if you have a slow machine, or limited bandwidth
# turning this off can vastly improve performance
# DEFAULT: true
show_album_art = "true"

# Amazon Developer Key
# This is needed in order to actually use the amazon album art
# DEFAULT: false
#amazon_developer_key = ""

# Amazon base urls
# An array of Amazon sites to search.
# NOTE: This will search each of these sites in turn so don't expect it
# to be lightening fast!
# It is strongly recommended that only one of these is selected at any
# one time
# Default: Just the US (.com)
amazon_base_urls = "http://webservices.amazon.com"
#amazon_base_urls = "http://webservices.amazon.co.uk"
#amazon_base_urls = "http://webservices.amazon.de"
#amazon_base_urls = "http://webservices.amazon.co.jp"
#amazon_base_urls = "http://webservices.amazon.fr"
#amazon_base_urls = "http://webservices.amazon.ca"

# max_amazon_results_pages
# The maximum number of results pages to pull from EACH amazon site
# NOTE: The art search pages through the results returned by your search
# up to this number of pages. As with the base_urls above, this is going
# to take more time, the more pages you ask it to process.
# Of course a good search will return only a few matches anyway.
# It is strongly recommended that you do _not_ change this value
# DEFAULT: 1 page (10 items)
max_amazon_results_pages = 1

# Debug
# If this is enabled Ampache will get really chatty
# warning this can crash browser during catalog builds due to 
# the amount of text that is dumped out this will also cause 
# ampache to write to the log file
# DEFAULT: false
#debug = "false"

# Debug Level
# This should always be set in conjunction with the
# debug option, it defines how prolific you want the
# debugging in ampache to be. values are 1-5. 
# 1 == Errors only
# 2 == Error + Failures (login attempts etc.)
# 3 == ??
# 4 == ?? (Profit!)
# 5 == Information (cataloging progress etc.)
# DEFAULT: 5
debug_level = 5

# Path to Log File
# This defines where you want ampache to log events to
# this will only happen if debug is turned on. Do not
# include trailing slash. You will need to make sure that
# your HTTP server has write access to the specified directory
# DEFAULT: NULL
#log_path = "/var/log/ampache"

# Charset of generated HTML pages
# Default of UTF-8 should work for most people
# DEFAULT: UTF-8
site_charset = UTF-8

# Locale Charset 
# In some cases this has to be different
# in order for XHTML and other things to work
# This is disabled by default, enabled only 
# if needed. It's specifically needed for Russian
# so that is the default
# DEFAULT: cp1251
#lc_charset = cp1251

# Refresh Limit
# This defines the default refresh limit in seconds for 
# pages with dynamic content, such as now playing
# DEFAULT: 60
# Possible Values: Int > 5
refresh_limit = "60"

##########################################################
# LDAP login info (optional)                             #
##########################################################

# This setting will silently create an ampache account
# for anyone who can login using ldap (or any other login
# extension) 
# DEFAULT: false
#auto_create = "false"

# LDAP filter string to use
# For OpenLDAP use "uid" 
# For Microsoft Active Directory (MAD) use "sAMAccountName"
# DEFAULT: null
# ldap_filter = "uid"
# ldap_filter = "sAMAccountName"

# LDAP objectclass it's required so if you don't know use *
# OpanLDAP objectclass = "*"
# MAD objectclass = "organizationalPerson"
# DEFAULT null
#ldap_objectclass = "*"
#ldap_objectclass = "organizationalPerson"

# if this is the case, fill these in here:
# DEFAULT: null
#ldap_username = ""
#ldap_password = ""

# NOT YET IMPLEMENTED!!
# This option checks to see if the specified user is in
# a specific ldap group, allowing you to give access based
# on group membership
# DEFAULT: null
#ldap_require_group = "cn=yourgroup,ou=yourorg,dc=yoursubdomain,dc=yourdomain,dc=yourtld"

# This is the search dn used to find your user, uid=username is added on to 
# This string 
# DEFAULT: null
#ldap_search_dn = "ou=People,dc=yoursubdomain,dc=yourdomain,dc=yourtld"

# This is the address of your ldap server
# DEFAULT: null
#ldap_url = ""

# Specify where in your ldap db the following fields are stored:
# (comment out if you don't have them)
# OpenLDAP: ldap_name_field = "cn"
# MAD ldap_name_field = "displayname"
# DEFAULT: [none]
#ldap_email_field = "mail"
#ldap_name_field  = "cn"

##########################################################
# Public Registration settings, defaults to disabled     #
##########################################################

# This setting turns on/off public registration. It is
# recommended you leave this off, as it will allow anyone to
# sign up for an account on your server.
# REMEMBER: don't forget to set the mail from address further down in the config.
# DEFAULT: false
#allow_public_registration = "false"

# Require Captcha Text on Image confirmation
# Turning this on requires the user to correctly
# type in the letters in the image created by Captcha
# Default is off because its very hard to detect if it failed
# to draw, or they failed to enter it.
# DEFAULT: false
#captcha_public_reg = "false"

# This setting defines the mail domain your in.
# It tries to deliver a test mail before the user can register and uses
# the from address info@"domain.tld". No mail is send from this address it's
# only used to test the existence of a mailbox before accepting user registration.
# DEFAULT: domain.tld
#mail_domain = "domain.tld"

# This setting will be used as mail from address.
# It will also be used to notify if a registration occurred.
# You need to change this when you activate public_registration.
#mail_from = "info@domain.tld"

# This setting turns on/off admin notify off registration.
# DEFAULT: false
#admin_notify_reg = "false"

# This setting will allow all registrants to be auto-approved
# as a user. By default, they will be added as a guest and
# must be "promoted" by the admin.
# POSSIBLE VALUES: guest, user, admin
# DEFAULT: guest
#auto_user = "guest"

# This will display the user agreement when registering
# For agreement text, edit templates/user_agreement.php
# User will need to accept the agreement before they can register
# DEFAULT: false
#user_agreement = "false"

#########################################################
# These options control the dynamic down-sampling based #
# on current usage                                      #
# *Note* Down-sampling must be enabled and working      #
#########################################################

# Attempt to optimize bandwidth by dynamically down-sampling
# all connections from users to fit within a maximum bandwidth.   
# The benefit is that it won't downsample more than it needs to.  As it only 
# adjusts the sample rate at the beginning of a song, it may take a few 
# minutes to reset all connections to a lower rate. This won't never go higher
# than a user's sample rate and only applies to users who are set to 
# the Downsample playback method
# DEFAULT: 576
#max_bit_rate = 576

# If min_bit_rate is set then new streams will be denied if it would
# cause all streams to be down-sampled below this rate.
# DEFAULT: 48
#min_bit_rate = 48


#######################################################
# These options control how searching works           #
#######################################################

# choices are: artist,album,song_title,song_genre,song_year,song_bitrate,song_min_bitrate,song_filename
# DEFAULT: song_title
search_field = song_title

# choices are: exact,fuzzy
# DEFAULT: fuzzy
search_type  = fuzzy 

#######################################################
# This option controls what Ampache sends for the Stream name. This
# is most valuable when then 'Type of Playback' is set to downsample.
# because lame seems to strip id3 tags. if you want the Ampache default
# just leave this option commented out.
#
# the format supports the following options:
#
# %A = album name
# %a = artist name
# %C = catalog path
# %c = id3 comment
# %g = genre
# %T = track number
# %t = song title
# %y = year
# %basename = current filename (just the actual filename)
# %catalog  = catalog name
# %filename = current filename (full path)
# %type     = song type (mp3, ogg, ...)
#
# DEFAULT: %a - %A - %t
#stream_name_format  = %a - %A - %t 


#######################################################
# These options control the down-sampling feature
# this requires you to install some applications such 
# as lame that can re-encode the mp3 for you.
# we recommend mp3splt and lame
# %FILE%	= filename
# %OFFSET%	= offset
# %SAMPLE%	= sample rate
# %EOF%		= end of file in min.sec
# DEFAULT: mp3splt -qnf %FILE% %OFFSET% %EOF% -o - | lame --mp3input -q 3 -b %SAMPLE% -S - -
downsample_cmd	= mp3splt -qnf %FILE% %OFFSET% %EOF% -o - | lame --mp3input -q 3 -b %SAMPLE% -S - -

#######################################################
# These are commands used to transcode non-streaming
# formats to the target file type for streaming. Any
# file types defined here will automatically be transcoded
# using the stream_cmd_??? regardless of personal preferences
# This can be useful in re-encoding file types that don't stream
# very well, or if the player doesn't support some file types. 
# REQUIRED variables
# transcode_TYPE	= true
# transcode_TYPE_target	= TARGET_FILE_TYPE
# stream_cmd_TYPE	= TRANSCODE_COMMAND

# List of filetypes to transcode
transcode_m4a 		= true
transcode_m4a_target 	= mp3 
transcode_flac 		= true
transcode_flac_target	= mp3
#transcode_mpc  	= false
#transcode_mpc_target	= mp3

# These are the commands that will be run to transcode the file
stream_cmd_flac 	= flac -dc %FILE% | lame -b 128 -S - - 
stream_cmd_m4a 		= faad -f 2 -w %FILE% | lame -b 128 -S - -
#stream_cmd_mpc		= 

#######################################################
# these options allow you to configure your rss-feed
# layout. rss exists of two parts, main and song
# main is the information about the feed
# song is the information in the feed. can be multiple
#      items.
#
# use_rss = false (values true | false)
#
#DEFAULT: use_rss = false 
#use_rss = false
#
#
# rss_main_title = the title for your feed.
# DEFAULT: Ampache for the love of Music
rss_main_title = Ampache for the love of Music
# rss_main_description = the description for your feed
# DEFAULT: Rss feed for Ampache so you can monitor who is listening to what
rss_main_description = Rss feed for Ampache so you can monitor who is listening to what
# rss_main_copyright = here you can enter copyright information if you wish
# DEFAULT: copyright (c) Speedy B for Ampache
rss_main_copyright = copyright (c) Speedy B for Ampache
# rss_song_description = The description of the song.
#                        It has to start with <![CDATA[
#                        and end with ]]>. this is because xml wont parse if strange
#                        characters are used in the id3-tag
# usable items:
# $song->f_title
# $song->f_album
# $user->fullname
# $artist
# $album
# DEFAULT:  <![CDATA[$song->f_title @ $album played by  $user->fullname]]>
# FIXME it's hardcoded in lib/rss.lib.php now
#rss_song_description = <![CDATA[$song->f_title @ $album played by  $user->fullname]]>
######################################################

