-- MySQL dump 10.13  Distrib 5.1.41, for debian-linux-gnu (i486)
--
-- Host: localhost    Database: copper
-- ------------------------------------------------------
-- Server version	5.1.41-3ubuntu12.6

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `cpg15x_albums`
--

DROP TABLE IF EXISTS `cpg15x_albums`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_albums` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `visibility` int(11) NOT NULL DEFAULT '0',
  `uploads` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `comments` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `votes` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `pos` int(11) NOT NULL DEFAULT '0',
  `category` int(11) NOT NULL DEFAULT '0',
  `owner` int(11) NOT NULL DEFAULT '1',
  `thumb` int(11) NOT NULL DEFAULT '0',
  `keyword` varchar(50) DEFAULT NULL,
  `alb_password` varchar(32) DEFAULT NULL,
  `alb_password_hint` text,
  `moderator_group` int(11) NOT NULL DEFAULT '0',
  `alb_hits` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `alb_category` (`category`),
  KEY `moderator_group` (`moderator_group`),
  KEY `visibility` (`visibility`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Used to store albums';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_albums`
--

LOCK TABLES `cpg15x_albums` WRITE;
/*!40000 ALTER TABLE `cpg15x_albums` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_albums` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_banned`
--

DROP TABLE IF EXISTS `cpg15x_banned`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_banned` (
  `ban_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `ip_addr` tinytext,
  `expiry` datetime DEFAULT NULL,
  `brute_force` tinyint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ban_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Data about banned users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_banned`
--

LOCK TABLES `cpg15x_banned` WRITE;
/*!40000 ALTER TABLE `cpg15x_banned` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_banned` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_bridge`
--

DROP TABLE IF EXISTS `cpg15x_bridge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_bridge` (
  `name` varchar(40) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Stores the bridging data, not used when unbridged';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_bridge`
--

LOCK TABLES `cpg15x_bridge` WRITE;
/*!40000 ALTER TABLE `cpg15x_bridge` DISABLE KEYS */;
INSERT INTO `cpg15x_bridge` VALUES ('short_name',''),('full_forum_url',''),('relative_path_to_config_file',''),('use_post_based_groups',''),('cookie_prefix',''),('recovery_logon_failures','0'),('recovery_logon_timestamp','');
/*!40000 ALTER TABLE `cpg15x_bridge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_categories`
--

DROP TABLE IF EXISTS `cpg15x_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_categories` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `pos` int(11) NOT NULL DEFAULT '0',
  `parent` int(11) NOT NULL DEFAULT '0',
  `thumb` int(11) NOT NULL DEFAULT '0',
  `lft` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rgt` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `depth` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `cat_parent` (`parent`),
  KEY `cat_pos` (`pos`),
  KEY `cat_owner_id` (`owner_id`),
  KEY `depth_cid` (`depth`,`cid`),
  KEY `lft_depth` (`lft`,`depth`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Used to store categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_categories`
--

LOCK TABLES `cpg15x_categories` WRITE;
/*!40000 ALTER TABLE `cpg15x_categories` DISABLE KEYS */;
INSERT INTO `cpg15x_categories` VALUES (1,0,'User galleries','This category contains albums that belong to Coppermine users.',0,0,0,1,2,1);
/*!40000 ALTER TABLE `cpg15x_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_categorymap`
--

DROP TABLE IF EXISTS `cpg15x_categorymap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_categorymap` (
  `cid` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Holds the categories where groups can create albums';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_categorymap`
--

LOCK TABLES `cpg15x_categorymap` WRITE;
/*!40000 ALTER TABLE `cpg15x_categorymap` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_categorymap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_comments`
--

DROP TABLE IF EXISTS `cpg15x_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_comments` (
  `pid` mediumint(10) NOT NULL DEFAULT '0',
  `msg_id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `msg_author` varchar(25) NOT NULL DEFAULT '',
  `msg_body` text NOT NULL,
  `msg_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `msg_raw_ip` tinytext,
  `msg_hdr_ip` tinytext,
  `author_md5_id` varchar(32) NOT NULL DEFAULT '',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `approval` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `spam` enum('YES','NO') NOT NULL DEFAULT 'NO',
  PRIMARY KEY (`msg_id`),
  KEY `com_pic_id` (`pid`),
  KEY `author_id` (`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to store comments made on pics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_comments`
--

LOCK TABLES `cpg15x_comments` WRITE;
/*!40000 ALTER TABLE `cpg15x_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_config`
--

DROP TABLE IF EXISTS `cpg15x_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_config` (
  `name` varchar(40) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to store the configuration options';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_config`
--

LOCK TABLES `cpg15x_config` WRITE;
/*!40000 ALTER TABLE `cpg15x_config` DISABLE KEYS */;
INSERT INTO `cpg15x_config` VALUES ('admin_activation','0'),('alb_desc_thumb','1'),('alb_list_thumb_size','50'),('album_list_cols','2'),('albums_per_page','12'),('allow_duplicate_emails_addr','0'),('allow_guests_enter_file_details','0'),('allowed_doc_types','doc/txt/rtf/pdf/xls/pps/ppt/zip/gz/mdb'),('allowed_img_types','jpeg/jpg/png/gif'),('allowed_mov_types','asf/asx/mpg/mpeg/wmv/swf/avi/mov'),('allowed_snd_types','mp3/midi/mid/wma/wav/ogg'),('allow_email_change','0'),('allow_memberlist','0'),('allow_private_albums','1'),('allow_unlogged_access','3'),('allow_user_account_delete','0'),('allow_user_album_keyword','0'),('allow_user_edit_after_cat_close','0'),('allow_user_move_album','0'),('allow_user_registration','0'),('allow_user_upload_choice','1'),('auto_resize','1'),('batch_proc_limit','2'),('bridge_enable','0'),('browse_batch_add','1'),('browse_by_date','0'),('caption_in_thumbview','1'),('categories_alpha_sort','0'),('charset','utf-8'),('clickable_keyword_search','1'),('comment_akismet_api_key',''),('comment_akismet_counter','0'),('comment_akismet_enable','0'),('comment_akismet_group','0'),('comment_approval','0'),('comment_captcha','1'),('comment_placeholder','1'),('comment_promote_registration','0'),('comments_anon_pfx','Guest_'),('comments_per_page','20'),('comments_sort_descending','0'),('comment_user_edit','1'),('contact_form_guest_email_field','2'),('contact_form_guest_enable','0'),('contact_form_guest_name_field','2'),('contact_form_registered_enable','1'),('contact_form_sender_email','1'),('contact_form_subject_content','Coppermine gallery contact form'),('contact_form_subject_field','0'),('cookie_name','cpg15x'),('cookie_path','/'),('count_admin_hits','0'),('count_album_hits','1'),('count_file_hits','1'),('custom_footer_path',''),('custom_header_path',''),('custom_lnk_name',''),('custom_lnk_url',''),('debug_mode','0'),('debug_notice','0'),('default_dir_mode','0755'),('default_file_mode','0644'),('default_sort_order','na'),('disable_comment_flood_protect','0'),('display_comment_approval_only','0'),('display_comment_count','0'),('display_coppermine_news','1'),('display_filename','0'),('display_film_strip','1'),('display_pic_info','0'),('display_redirection_page','0'),('display_reset_boxes_in_config','0'),('display_sidebar_guest','1'),('display_sidebar_user','1'),('display_stats_on_index','1'),('display_thumbnail_rating','0'),('display_thumbs_batch_add','1'),('display_uploader','0'),('display_xp_publish_link','0'),('ecard_flash','0'),('ecards_more_pic_target','http://192.168.1.135/'),('email_comment_notification','0'),('enable_encrypted_passwords','1'),('enable_help','1'),('enable_menu_icons','2'),('enable_plugins','1'),('enable_smilies','1'),('enable_thumb_watermark','1'),('enable_unsharp','0'),('enable_watermark','0'),('enable_zipdownload','0'),('filter_bad_words','0'),('first_level','1'),('forbiden_fname_char','$/\\\\:*?&quot;&#039;&lt;&gt;|` &amp;#@'),('fullpath','albums/'),('fullsize_padding_x','5'),('fullsize_padding_y','3'),('gallery_admin_email','admin@example.com'),('gallery_description','Your gallery description here'),('gallery_name','Your gallery name here'),('global_registration_pw',''),('guest_token_cleanup','1283983278'),('hit_details','0'),('home_target','index.php'),('im_options','-antialias'),('impath','/usr/bin/'),('jpeg_qual','80'),('keep_votes_time','30'),('keyword_separator',';'),('lang','english'),('language_autodetect','1'),('link_pic_count','1'),('log_ecards','0'),('login_expiry','10'),('login_method','username'),('login_threshold','5'),('log_mode','0'),('main_page_layout','breadcrumb/catlist/alblist/random,2/lastup,2'),('main_table_width','100%'),('make_intermediate','1'),('max_com_lines','10'),('max_com_size','512'),('max_com_wlength','38'),('max_film_strip_items','5'),('max_img_desc_length','512'),('max_tabs','12'),('max_upl_size','1024'),('max_upl_width_height','2048'),('media_autostart','1'),('min_votes_for_rating','1'),('normal_pfx','normal_'),('offline','0'),('old_style_rating','0'),('orig_pfx','orig_'),('performance_page_generation_time','0'),('performance_page_query_count','0'),('performance_page_query_time','0'),('performance_timestamp','0'),('personal_album_on_registration','0'),('picinfo_movie_download_link','1'),('picture_table_width','100%'),('picture_use','thumb'),('picture_width','400'),('purge_expired_bans','1'),('rate_own_files','0'),('rating_stars_amount','5'),('read_exif_data','0'),('read_iptc_data','0'),('reduce_watermark','0'),('registration_captcha','0'),('reg_notify_admin_email','0'),('reg_requires_valid_email','1'),('report_post','0'),('session_cleanup','1283989900'),('show_bbcode_help','1'),('show_private','0'),('show_which_exif','|0|0|0|0|0|0|0|0|1|0|1|1|0|0|0|0|0|0|0|0|0|0|0|1|0|0|0|1|0|0|0|1|1|0|0|0|0|1|0|0|0|1|0|0|1|1|0|0|0|0|0|1|0|1|1'),('silly_safe_mode','0'),('site_token','8e6b20efd21bc1ba7f11e7e7b1b05465'),('form_token_lifetime','900'),('slideshow_hits','1'),('slideshow_interval','5000'),('smtp_host',''),('smtp_password',''),('smtp_username',''),('subcat_level','2'),('tabs_dropdown','1'),('theme','curve'),('theme_list','0'),('thumbcols','4'),('thumb_height','128'),('thumb_method','im'),('thumbnail_to_fullsize','0'),('thumb_pfx','thumb_'),('thumbrows','3'),('thumb_use','any'),('thumb_width','128'),('time_offset','0'),('transparent_overlay','0'),('unsharp_amount','120'),('unsharp_radius','0.5'),('unsharp_threshold','3'),('upl_notify_admin_email','0'),('upload_mechanism','swfupload'),('user_field1_name',''),('user_field2_name',''),('user_field3_name',''),('user_field4_name',''),('userpics','userpics/'),('user_profile1_name','Location'),('user_profile2_name','Interests'),('user_profile3_name','Website'),('user_profile4_name','Occupation'),('user_profile5_name',''),('user_profile6_name','Biography'),('user_registration_disclaimer','1'),('users_can_edit_pics','0'),('views_in_thumbview','1'),('vote_details','0'),('watermark_file','images/watermark.png'),('watermark_transparency','40'),('watermark_transparency_featherx','0'),('watermark_transparency_feathery','0'),('where_put_watermark','southeast'),('which_files_to_watermark','both');
/*!40000 ALTER TABLE `cpg15x_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_dict`
--

DROP TABLE IF EXISTS `cpg15x_dict`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_dict` (
  `keyId` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(60) NOT NULL,
  PRIMARY KEY (`keyId`),
  UNIQUE KEY `keyword` (`keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Holds the keyword dictionary';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_dict`
--

LOCK TABLES `cpg15x_dict` WRITE;
/*!40000 ALTER TABLE `cpg15x_dict` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_dict` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_ecards`
--

DROP TABLE IF EXISTS `cpg15x_ecards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_ecards` (
  `eid` int(11) NOT NULL AUTO_INCREMENT,
  `sender_name` varchar(50) NOT NULL DEFAULT '',
  `sender_email` text NOT NULL,
  `recipient_name` varchar(50) NOT NULL DEFAULT '',
  `recipient_email` text NOT NULL,
  `link` text NOT NULL,
  `date` tinytext NOT NULL,
  `sender_ip` tinytext NOT NULL,
  PRIMARY KEY (`eid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to log ecards';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_ecards`
--

LOCK TABLES `cpg15x_ecards` WRITE;
/*!40000 ALTER TABLE `cpg15x_ecards` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_ecards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_exif`
--

DROP TABLE IF EXISTS `cpg15x_exif`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_exif` (
  `pid` int(11) NOT NULL,
  `exifData` text NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Stores EXIF data from individual pics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_exif`
--

LOCK TABLES `cpg15x_exif` WRITE;
/*!40000 ALTER TABLE `cpg15x_exif` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_exif` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_favpics`
--

DROP TABLE IF EXISTS `cpg15x_favpics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_favpics` (
  `user_id` int(11) NOT NULL,
  `user_favpics` text NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Stores the server side favourites';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_favpics`
--

LOCK TABLES `cpg15x_favpics` WRITE;
/*!40000 ALTER TABLE `cpg15x_favpics` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_favpics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_filetypes`
--

DROP TABLE IF EXISTS `cpg15x_filetypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_filetypes` (
  `extension` char(7) NOT NULL DEFAULT '',
  `mime` char(254) DEFAULT NULL,
  `content` char(15) DEFAULT NULL,
  `player` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`extension`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to store the file extensions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_filetypes`
--

LOCK TABLES `cpg15x_filetypes` WRITE;
/*!40000 ALTER TABLE `cpg15x_filetypes` DISABLE KEYS */;
INSERT INTO `cpg15x_filetypes` VALUES ('jpg','image/jpg','image',''),('jpeg','image/jpeg','image',''),('jpe','image/jpe','image',''),('gif','image/gif','image',''),('png','image/png','image',''),('bmp','image/bmp','image',''),('jpc','image/jpc','image',''),('jp2','image/jp2','image',''),('jpx','image/jpx','image',''),('jb2','image/jb2','image',''),('swc','image/swc','image',''),('iff','image/iff','image',''),('psd','image/psd','image',''),('asf','video/x-ms-asf','movie','WMP'),('asx','video/x-ms-asx','movie','WMP'),('mpg','video/mpeg','movie','WMP'),('mpeg','video/mpeg','movie','WMP'),('wmv','video/x-ms-wmv','movie','WMP'),('swf','application/x-shockwave-flash','movie','SWF'),('avi','video/avi','movie','WMP'),('mov','video/quicktime','movie','QT'),('mp3','audio/mpeg3','audio','WMP'),('midi','audio/midi','audio','WMP'),('mid','audio/midi','audio','WMP'),('wma','audio/x-ms-wma','audio','WMP'),('wav','audio/wav','audio','WMP'),('ogg','audio/ogg','audio','HTMLA'),('oga','audio/ogg','audio','HTMLA'),('ogv','video/ogg','movie','HTMLV'),('ram','audio/x-pn-realaudio','document','RMP'),('ra','audio/x-realaudio','document','RMP'),('rm','audio/x-realmedia','document','RMP'),('tiff','image/tiff','document',''),('tif','image/tif','document',''),('doc','application/msword','document',''),('xls','application/excel','document',''),('pps','application/powerpoint','document',''),('ppt','application/powerpoint','document',''),('mdb','application/msaccess','document',''),('txt','text/plain','document',''),('rtf','text/richtext','document',''),('pdf','application/pdf','document',''),('zip','application/zip','document',''),('rar','application/rar','document',''),('gz','application/gz','document',''),('001','application/001','document',''),('7z','application/7z','document',''),('arj','application/arj','document',''),('bz2','application/bz2','document',''),('cab','application/cab','document',''),('lzh','application/lzh','document',''),('rpm','application/rpm','document',''),('tar','application/tar','document',''),('z','application/z','document',''),('odb','application/vnd.oasis.opendocument.database','document',''),('odt','application/vnd.oasis.opendocument.text','document',''),('ods','application/vnd.oasis.opendocument.spreadsheet','document',''),('odp','application/vnd.oasis.opendocument.presentation','document',''),('odg','application/vnd.oasis.opendocument.graphics','document',''),('odc','application/vnd.oasis.opendocument.chart','document',''),('odf','application/vnd.oasis.opendocument.formula','document',''),('odi','application/vnd.oasis.opendocument.image','document',''),('odm','application/vnd.oasis.opendocument.text-master','document',''),('ott','application/vnd.oasis.opendocument.text-template','document',''),('ots','application/vnd.oasis.opendocument.spreadsheet-template','document',''),('otp','application/vnd.oasis.opendocument.presentation-template','document',''),('otg','application/vnd.oasis.opendocument.graphics-template','document',''),('otc','application/vnd.oasis.opendocument.chart-template','document',''),('otf','application/vnd.oasis.opendocument.formula-template','document',''),('oti','application/vnd.oasis.opendocument.image-template','document',''),('oth','application/vnd.oasis.opendocument.text-web','document',''),('sxw','application/vnd.sun.xml.writer','document',''),('stw','application/vnd.sun.xml.writer.template','document',''),('sxc','application/vnd.sun.xml.calc','document',''),('stc','application/vnd.sun.xml.calc.template','document',''),('sxd','application/vnd.sun.xml.draw','document',''),('std','application/vnd.sun.xml.draw.template','document',''),('sxi','application/vnd.sun.xml.impress','document',''),('sti','application/vnd.sun.xml.impress.template','document',''),('sxg','application/vnd.sun.xml.writer.global','document',''),('sxm','application/vnd.sun.xml.math','document',''),('docx','application/vnd.openxmlformats-officedocument.wordprocessingml.document','document',''),('docm','application/vnd.ms-word.document.macroEnabled.12','document',''),('dotx','application/vnd.openxmlformats-officedocument.wordprocessingml.template','document',''),('dotm','application/vnd.ms-word.template.macroEnabled.12','document',''),('xlsx','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet','document',''),('xlsm','application/vnd.ms-excel.sheet.macroEnabled.12','document',''),('xltx','application/vnd.openxmlformats-officedocument.spreadsheetml.template','document',''),('xltm','application/vnd.ms-excel.template.macroEnabled.12','document',''),('xlsb','application/vnd.ms-excel.sheet.binary.macroEnabled.12','document',''),('xlam','application/vnd.ms-excel.addin.macroEnabled.12','document',''),('pptx','application/vnd.openxmlformats-officedocument.presentationml.presentation','document',''),('pptm','application/vnd.ms-powerpoint.presentation.macroEnabled.12','document',''),('ppsx','application/vnd.openxmlformats-officedocument.presentationml.slideshow','document',''),('ppsm','application/vnd.ms-powerpoint.slideshow.macroEnabled.12','document',''),('potx','application/vnd.openxmlformats-officedocument.presentationml.template','document',''),('potm','application/vnd.ms-powerpoint.template.macroEnabled.12','document',''),('ppam','application/vnd.ms-powerpoint.addin.macroEnabled.12','document',''),('sldx','application/vnd.openxmlformats-officedocument.presentationml.slide','document',''),('sldm','application/vnd.ms-powerpoint.slide.macroEnabled.12','document',''),('thmx','application/vnd.ms-officetheme','document',''),('onetoc','application/onenote','document',''),('onetoc2','application/onenote','document',''),('onetmp','application/onenote','document',''),('onepkg','application/onenote','document','');
/*!40000 ALTER TABLE `cpg15x_filetypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_hit_stats`
--

DROP TABLE IF EXISTS `cpg15x_hit_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_hit_stats` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(100) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `search_phrase` varchar(255) NOT NULL DEFAULT '',
  `sdate` bigint(20) NOT NULL DEFAULT '0',
  `referer` text NOT NULL,
  `browser` varchar(255) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Detailed stats about hits, only used when enabled';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_hit_stats`
--

LOCK TABLES `cpg15x_hit_stats` WRITE;
/*!40000 ALTER TABLE `cpg15x_hit_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_hit_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_languages`
--

DROP TABLE IF EXISTS `cpg15x_languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_languages` (
  `lang_id` varchar(40) NOT NULL DEFAULT '',
  `english_name` varchar(70) DEFAULT NULL,
  `native_name` varchar(70) DEFAULT NULL,
  `custom_name` varchar(70) DEFAULT NULL,
  `flag` varchar(15) DEFAULT NULL,
  `abbr` varchar(15) NOT NULL DEFAULT '',
  `available` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `enabled` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `complete` enum('YES','NO') NOT NULL DEFAULT 'NO',
  PRIMARY KEY (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Contains the language file definitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_languages`
--

LOCK TABLES `cpg15x_languages` WRITE;
/*!40000 ALTER TABLE `cpg15x_languages` DISABLE KEYS */;
INSERT INTO `cpg15x_languages` VALUES ('albanian','Albanian','Albanian',NULL,'al','al','NO','NO','NO'),('arabic','Arabic','&#1575;&#1604;&#1593;&#1585;&#1576;&#1610;&#1577;',NULL,'sa','ar','YES','YES','NO'),('armenian','Armenian','',NULL,'','','NO','NO','NO'),('azerbaijani','Azerbaijani','',NULL,'az','','NO','NO','NO'),('basque','Basque','Euskera',NULL,'basque','','NO','NO','NO'),('bosnian','Bosnian','Bosanski',NULL,'ba','','NO','NO','NO'),('brazilian_portuguese','Portuguese (Brazilian)','Portugu&ecirc;s Brasileiro',NULL,'br','','YES','YES','NO'),('bulgarian','Bulgarian','&#1041;&#1098;&#1083;&#1075;&#1072;&#1088;&#1089;&#1082;&#1080;',NULL,'bg','','YES','YES','NO'),('byelorussian','Byelorussian','',NULL,'by','','NO','NO','NO'),('catalan','Catalan','Catal&agrave;',NULL,'catalonia','','NO','NO','NO'),('chinese_big5','Chinese traditional','&#20013;&#25991; - &#32321;&#39636;',NULL,'tw','cn','NO','NO','NO'),('chinese_gb','Chinese simplified','&#20013;&#25991; - &#31616;&#20307;',NULL,'cn','cn','YES','YES','NO'),('croatian','Croatian','Hrvatski',NULL,'hr','','NO','NO','NO'),('czech','Czech','&#x010C;esky',NULL,'cz','cz','YES','YES','NO'),('danish','Danish','Dansk',NULL,'dk','dk','YES','YES','NO'),('dutch','Dutch','Nederlands',NULL,'nl','nl','YES','NO','NO'),('english','English (US)','English (US)',NULL,'us','en','YES','YES','YES'),('english_gb','English (British)','English (British)',NULL,'gb','en','YES','YES','NO'),('estonian','Estonian','Eesti',NULL,'ee','ee','YES','YES','YES'),('filipino','Filipino Tagalog','',NULL,'ph','','NO','NO','NO'),('finnish','Finnish','Suomea',NULL,'fi','','YES','YES','YES'),('french','French','Fran&ccedil;ais',NULL,'fr','fr','YES','YES','YES'),('galician','Galician','Galego',NULL,'galician','','NO','NO','NO'),('georgian','Georgian','&#4325;&#4304;&#4320;&#4311;&#4323;&#4314;&#4312;',NULL,'ge','','NO','NO','NO'),('german','German (informal)','Deutsch (Du)',NULL,'de','de','YES','YES','YES'),('german_formal','German (formal)','Deutsch (Sie)',NULL,'de','de','YES','YES','YES'),('greek','Greek','&#917;&#955;&#955;&#951;&#957;&#953;&#954;&#940;',NULL,'gr','gr','YES','YES','YES'),('hebrew','Hebrew','&#1506;&#1489;&#1512;&#1497;&#1514;',NULL,'il','','NO','NO','NO'),('hindi','Hindi','&#2361;&#2367;&#2344;&#2381;&#2342;&#2368;',NULL,'in','','NO','NO','NO'),('hungarian','Hungarian','Magyarul',NULL,'hu','','YES','YES','NO'),('icelandic','Icelandic','',NULL,'is','','NO','NO','NO'),('indonesian','Indonesian','Bahasa Indonesia',NULL,'id','','NO','NO','NO'),('italian','Italian','Italiano',NULL,'it','it','NO','NO','NO'),('japanese','Japanese','&#26085;&#26412;&#35486;',NULL,'jp','jp','YES','YES','YES'),('kazakh','Kazakh','',NULL,'kz','','NO','NO','NO'),('korean','Korean','&#54620;&#44397;&#50612;',NULL,'kr','','NO','NO','NO'),('kurdish','Kurdish','&#1603;&#1608;&#1585;&#1583;&#1740;',NULL,'kurdish','','NO','NO','NO'),('kyrgyz','Kyrgyz','',NULL,'kg','','NO','NO','NO'),('laothian','Laothian ','',NULL,'la','','NO','NO','NO'),('latvian','Latvian','Latvian',NULL,'lv','','NO','NO','NO'),('lithuanian','Lithuanian','Letzeburgisch',NULL,'lu','','NO','NO','NO'),('luxembourgish','Luxembourgish','Lietuvi&#0353;kai',NULL,'lt','','YES','YES','NO'),('macedonian','Macedonian','&#1052;&#1072;&#1082;&#1077;&#1076;&#1086;&#1085;&#1089;&#1082;&#1080;',NULL,'mk','','NO','NO','NO'),('malay','Malay','Bahasa Melayu',NULL,'my','','NO','NO','NO'),('maltese','Maltese','',NULL,'mt','','NO','NO','NO'),('mongolian','Mongolian','',NULL,'mn','','NO','NO','NO'),('nepali','Nepali','',NULL,'np','','NO','NO','NO'),('norwegian','Norwegian','Norsk',NULL,'no','no','NO','NO','NO'),('persian','Persian','&#1601;&#1575;&#1585;&#1587;&#1740;',NULL,'ir','','NO','NO','NO'),('polish','Polish','Polski',NULL,'pl','pl','YES','YES','YES'),('portuguese','Portuguese (Portugal)','Portugu&ecirc;s',NULL,'pt','','NO','NO','NO'),('romanian','Romanian','Rom&acirc;n&atilde;',NULL,'ro','','NO','NO','NO'),('russian','Russian','&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;',NULL,'ru','ru','YES','YES','YES'),('slovak','Slovak','Slovensky',NULL,'sk','','YES','YES','NO'),('slovenian','Slovenian','Slovensko',NULL,'si','','YES','YES','NO'),('spanish','Spanish','Espa&ntilde;ol',NULL,'es','es','YES','YES','YES'),('spanish_mx','Mexican Spanish','Espa&ntilde;ol mexicano',NULL,'mx','mx','YES','YES','NO'),('swedish','Swedish','Svenska',NULL,'se','','NO','NO','NO'),('thai','Thai','&#3652;&#3607;&#3618;',NULL,'th','','NO','NO','NO'),('turkish','Turkish','T&uuml;rk&ccedil;e',NULL,'tr','','YES','YES','NO'),('tigrinya','Tigrinya','',NULL,'er','','NO','NO','NO'),('twi','Twi','',NULL,'gh','','NO','NO','NO'),('uighur','Uighur','Uighur',NULL,'uighur','','NO','NO','NO'),('ukrainian','Ukrainian','&#1059;&#1082;&#1088;&#1072;&#1111;&#1085;&#1089;&#1100;&#1082;&#1072;',NULL,'ua','','YES','YES','YES'),('uzbek','Uzbek','',NULL,'uz','','NO','NO','NO'),('vietnamese','Vietnamese','Tieng Viet',NULL,'vn','','NO','NO','NO'),('welsh','Welsh','Cymraeg',NULL,'wales','','NO','NO','NO');
/*!40000 ALTER TABLE `cpg15x_languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_pictures`
--

DROP TABLE IF EXISTS `cpg15x_pictures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_pictures` (
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL DEFAULT '0',
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `total_filesize` int(11) NOT NULL DEFAULT '0',
  `pwidth` smallint(6) NOT NULL DEFAULT '0',
  `pheight` smallint(6) NOT NULL DEFAULT '0',
  `hits` int(10) NOT NULL DEFAULT '0',
  `mtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ctime` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `pic_rating` int(11) NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `caption` text NOT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `approved` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `galleryicon` int(11) NOT NULL DEFAULT '0',
  `user1` varchar(255) NOT NULL DEFAULT '',
  `user2` varchar(255) NOT NULL DEFAULT '',
  `user3` varchar(255) NOT NULL DEFAULT '',
  `user4` varchar(255) NOT NULL DEFAULT '',
  `url_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `pic_raw_ip` tinytext,
  `pic_hdr_ip` tinytext,
  `lasthit_ip` tinytext,
  `position` int(11) NOT NULL DEFAULT '0',
  `guest_token` varchar(32) DEFAULT '',
  PRIMARY KEY (`pid`),
  KEY `owner_id` (`owner_id`),
  KEY `pic_hits` (`hits`),
  KEY `pic_rate` (`pic_rating`),
  KEY `aid_approved` (`aid`,`approved`),
  KEY `pic_aid` (`aid`,`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Used to store data about individual pics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_pictures`
--

LOCK TABLES `cpg15x_pictures` WRITE;
/*!40000 ALTER TABLE `cpg15x_pictures` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_pictures` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_plugins`
--

DROP TABLE IF EXISTS `cpg15x_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_plugins` (
  `plugin_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(128) NOT NULL DEFAULT '',
  `priority` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`plugin_id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Stores the plugins';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_plugins`
--

LOCK TABLES `cpg15x_plugins` WRITE;
/*!40000 ALTER TABLE `cpg15x_plugins` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_sessions`
--

DROP TABLE IF EXISTS `cpg15x_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `remember` int(1) DEFAULT '0',
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to store sessions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_sessions`
--

LOCK TABLES `cpg15x_sessions` WRITE;
/*!40000 ALTER TABLE `cpg15x_sessions` DISABLE KEYS */;
INSERT INTO `cpg15x_sessions` VALUES ('a7b0e77c7df45baa622af7840983a233',1,1283989900,0);
/*!40000 ALTER TABLE `cpg15x_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_temp_messages`
--

DROP TABLE IF EXISTS `cpg15x_temp_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_temp_messages` (
  `message_id` varchar(80) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Used to store messages from one page to the other';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_temp_messages`
--

LOCK TABLES `cpg15x_temp_messages` WRITE;
/*!40000 ALTER TABLE `cpg15x_temp_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_temp_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_usergroups`
--

DROP TABLE IF EXISTS `cpg15x_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_usergroups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '',
  `group_quota` int(11) NOT NULL DEFAULT '0',
  `has_admin_access` tinyint(4) NOT NULL DEFAULT '0',
  `can_rate_pictures` tinyint(4) NOT NULL DEFAULT '0',
  `can_send_ecards` tinyint(4) NOT NULL DEFAULT '0',
  `can_post_comments` tinyint(4) NOT NULL DEFAULT '0',
  `can_upload_pictures` tinyint(4) NOT NULL DEFAULT '0',
  `can_create_albums` tinyint(4) NOT NULL DEFAULT '0',
  `pub_upl_need_approval` tinyint(4) NOT NULL DEFAULT '1',
  `priv_upl_need_approval` tinyint(4) NOT NULL DEFAULT '1',
  `access_level` tinyint(4) NOT NULL DEFAULT '3',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_usergroups`
--

LOCK TABLES `cpg15x_usergroups` WRITE;
/*!40000 ALTER TABLE `cpg15x_usergroups` DISABLE KEYS */;
INSERT INTO `cpg15x_usergroups` VALUES (1,'Administrators',0,1,1,1,1,1,1,0,0,3),(2,'Registered',1024,0,1,1,1,1,1,1,0,3),(3,'Anonymous',0,0,1,0,0,0,0,1,1,3);
/*!40000 ALTER TABLE `cpg15x_usergroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_users`
--

DROP TABLE IF EXISTS `cpg15x_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group` int(11) NOT NULL DEFAULT '2',
  `user_active` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `user_name` varchar(25) NOT NULL DEFAULT '',
  `user_password` varchar(40) NOT NULL DEFAULT '',
  `user_lastvisit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_regdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_group_list` varchar(255) NOT NULL DEFAULT '',
  `user_email` varchar(255) NOT NULL DEFAULT '',
  `user_profile1` varchar(255) NOT NULL DEFAULT '',
  `user_profile2` varchar(255) NOT NULL DEFAULT '',
  `user_profile3` varchar(255) NOT NULL DEFAULT '',
  `user_profile4` varchar(255) NOT NULL DEFAULT '',
  `user_profile5` varchar(255) NOT NULL DEFAULT '',
  `user_profile6` text NOT NULL,
  `user_actkey` varchar(32) NOT NULL DEFAULT '',
  `user_language` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `user_group` (`user_group`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Used to store users, not used when bridged';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_users`
--

LOCK TABLES `cpg15x_users` WRITE;
/*!40000 ALTER TABLE `cpg15x_users` DISABLE KEYS */;
INSERT INTO `cpg15x_users` VALUES (1,1,'YES','admin','21232f297a57a5a743894a0e4a801fc3','2010-09-08 23:51:50','2010-09-08 21:59:45','','admin@example.com','','','','','','','','english');
/*!40000 ALTER TABLE `cpg15x_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_vote_stats`
--

DROP TABLE IF EXISTS `cpg15x_vote_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_vote_stats` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(100) NOT NULL DEFAULT '',
  `rating` smallint(6) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `sdate` bigint(20) NOT NULL DEFAULT '0',
  `referer` text NOT NULL,
  `browser` varchar(255) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Detailed stats about votes, only used when enabled';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_vote_stats`
--

LOCK TABLES `cpg15x_vote_stats` WRITE;
/*!40000 ALTER TABLE `cpg15x_vote_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_vote_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpg15x_votes`
--

DROP TABLE IF EXISTS `cpg15x_votes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpg15x_votes` (
  `pic_id` mediumint(9) NOT NULL DEFAULT '0',
  `user_md5_id` varchar(32) NOT NULL DEFAULT '',
  `vote_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pic_id`,`user_md5_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Stores votes for individual pics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpg15x_votes`
--

LOCK TABLES `cpg15x_votes` WRITE;
/*!40000 ALTER TABLE `cpg15x_votes` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpg15x_votes` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2010-09-08 23:53:39
