<?php

//extract and clean relative path from html root
$pathpart = str_replace($_SERVER['DOCUMENT_ROOT'], "", $CONFIG->path);
$pathpart = str_replace("//", "/", $pathpart);
$pathpart = rtrim($pathpart, " \n\t\0\x0B/");
$pathpart = $pathpart . "/";

// set base url
$CONFIG->wwwroot = "http://" . $_SERVER['HTTP_HOST'] . $pathpart;
$CONFIG->url = $CONFIG->wwwroot;

// register for the init event during boot of the engine
register_elgg_event_handler('init', 'system', 'virtual_setup_init');


function virtual_setup_init() {
	global $CONFIG;
	
	// register for our custom front page
	register_plugin_hook('index', 'system', 'virtual_setup_front_page');

	// register settings save action
	register_action("virtual/save", TRUE, $CONFIG->pluginspath . "virtual_setup/actions/save.php");
}

function virtual_setup_front_page() {

	$title = elgg_echo('virtual_setup:install');
	
	$body = elgg_view_title($title);

	$body .= elgg_view('virtual_setup/setup');

	page_draw($title, $body);

	// we sent our front page so exit
	exit;
}