-- MySQL dump 10.11
--
-- Host: localhost    Database: elgg
-- ------------------------------------------------------
-- Server version	5.0.51a-3ubuntu5.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `elgg_access_collection_membership`
--

DROP TABLE IF EXISTS `elgg_access_collection_membership`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_access_collection_membership` (
  `user_guid` int(11) NOT NULL,
  `access_collection_id` int(11) NOT NULL,
  PRIMARY KEY  (`user_guid`,`access_collection_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_access_collection_membership`
--

LOCK TABLES `elgg_access_collection_membership` WRITE;
/*!40000 ALTER TABLE `elgg_access_collection_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_access_collection_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_access_collections`
--

DROP TABLE IF EXISTS `elgg_access_collections`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_access_collections` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `site_guid` (`site_guid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_access_collections`
--

LOCK TABLES `elgg_access_collections` WRITE;
/*!40000 ALTER TABLE `elgg_access_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_access_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_annotations`
--

DROP TABLE IF EXISTS `elgg_annotations`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_annotations` (
  `id` int(11) NOT NULL auto_increment,
  `entity_guid` bigint(20) unsigned NOT NULL,
  `name_id` int(11) NOT NULL,
  `value_id` int(11) NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name_id` (`name_id`),
  KEY `value_id` (`value_id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_annotations`
--

LOCK TABLES `elgg_annotations` WRITE;
/*!40000 ALTER TABLE `elgg_annotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_annotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_api_users`
--

DROP TABLE IF EXISTS `elgg_api_users`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_api_users` (
  `id` int(11) NOT NULL auto_increment,
  `site_guid` bigint(20) unsigned default NULL,
  `api_key` varchar(40) default NULL,
  `secret` varchar(40) NOT NULL,
  `active` int(1) default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `api_key` (`api_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_api_users`
--

LOCK TABLES `elgg_api_users` WRITE;
/*!40000 ALTER TABLE `elgg_api_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_api_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_config`
--

DROP TABLE IF EXISTS `elgg_config`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_config` (
  `name` varchar(32) NOT NULL,
  `value` text NOT NULL,
  `site_guid` int(11) NOT NULL,
  PRIMARY KEY  (`name`,`site_guid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_config`
--

LOCK TABLES `elgg_config` WRITE;
/*!40000 ALTER TABLE `elgg_config` DISABLE KEYS */;
INSERT INTO `elgg_config` VALUES ('view','s:7:\"default\";',1),('language','s:2:\"en\";',1),('default_access','s:1:\"1\";',1),('https_login','s:1:\"1\";',1),('allow_user_default_access','s:1:\"0\";',1),('ping_home','s:8:\"disabled\";',1);
/*!40000 ALTER TABLE `elgg_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_datalists`
--

DROP TABLE IF EXISTS `elgg_datalists`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_datalists` (
  `name` varchar(32) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_datalists`
--

LOCK TABLES `elgg_datalists` WRITE;
/*!40000 ALTER TABLE `elgg_datalists` DISABLE KEYS */;
INSERT INTO `elgg_datalists` VALUES ('__site_secret__','3c1e306592d046b88ff7a123e22df8d6'),('filestore_run_once','1273686714'),('plugin_run_once','1273686714'),('widget_run_once','1273686714'),('installed','1273686714'),('path','/var/www/'),('dataroot','/var/elgg-data/'),('default_site','1'),('version','2010040201'),('simplecache_lastupdate','1274357435'),('simplecache_default','1274357435'),('admin_registered','1'),('first_admin_login','1273686869'),('viewpath_cache_enabled','1');
/*!40000 ALTER TABLE `elgg_datalists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_entities`
--

DROP TABLE IF EXISTS `elgg_entities`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_entities` (
  `guid` bigint(20) unsigned NOT NULL auto_increment,
  `type` enum('object','user','group','site') NOT NULL,
  `subtype` int(11) default NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL,
  `container_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `time_updated` int(11) NOT NULL,
  `last_action` int(11) NOT NULL default '0',
  `enabled` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`guid`),
  KEY `type` (`type`),
  KEY `subtype` (`subtype`),
  KEY `owner_guid` (`owner_guid`),
  KEY `site_guid` (`site_guid`),
  KEY `container_guid` (`container_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `time_updated` (`time_updated`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_entities`
--

LOCK TABLES `elgg_entities` WRITE;
/*!40000 ALTER TABLE `elgg_entities` DISABLE KEYS */;
INSERT INTO `elgg_entities` VALUES (1,'site',0,0,0,0,2,1273686714,1274196634,0,'yes'),(2,'user',0,0,1,0,2,1273686842,1274357410,0,'yes');
/*!40000 ALTER TABLE `elgg_entities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_entity_relationships`
--

DROP TABLE IF EXISTS `elgg_entity_relationships`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_entity_relationships` (
  `id` int(11) NOT NULL auto_increment,
  `guid_one` bigint(20) unsigned NOT NULL,
  `relationship` varchar(50) NOT NULL,
  `guid_two` bigint(20) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `guid_one` (`guid_one`,`relationship`,`guid_two`),
  KEY `relationship` (`relationship`),
  KEY `guid_two` (`guid_two`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_entity_relationships`
--

LOCK TABLES `elgg_entity_relationships` WRITE;
/*!40000 ALTER TABLE `elgg_entity_relationships` DISABLE KEYS */;
INSERT INTO `elgg_entity_relationships` VALUES (1,2,'member_of_site',1);
/*!40000 ALTER TABLE `elgg_entity_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_entity_subtypes`
--

DROP TABLE IF EXISTS `elgg_entity_subtypes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_entity_subtypes` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('object','user','group','site') NOT NULL,
  `subtype` varchar(50) NOT NULL,
  `class` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `type` (`type`,`subtype`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_entity_subtypes`
--

LOCK TABLES `elgg_entity_subtypes` WRITE;
/*!40000 ALTER TABLE `elgg_entity_subtypes` DISABLE KEYS */;
INSERT INTO `elgg_entity_subtypes` VALUES (1,'object','file','ElggFile'),(2,'object','plugin','ElggPlugin'),(3,'object','widget','ElggWidget');
/*!40000 ALTER TABLE `elgg_entity_subtypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_geocode_cache`
--

DROP TABLE IF EXISTS `elgg_geocode_cache`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_geocode_cache` (
  `id` int(11) NOT NULL auto_increment,
  `location` varchar(128) default NULL,
  `lat` varchar(20) default NULL,
  `long` varchar(20) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `location` (`location`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_geocode_cache`
--

LOCK TABLES `elgg_geocode_cache` WRITE;
/*!40000 ALTER TABLE `elgg_geocode_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_geocode_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_groups_entity`
--

DROP TABLE IF EXISTS `elgg_groups_entity`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_groups_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY  (`guid`),
  KEY `name` (`name`(50)),
  KEY `description` (`description`(50)),
  FULLTEXT KEY `name_2` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_groups_entity`
--

LOCK TABLES `elgg_groups_entity` WRITE;
/*!40000 ALTER TABLE `elgg_groups_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_groups_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_hmac_cache`
--

DROP TABLE IF EXISTS `elgg_hmac_cache`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_hmac_cache` (
  `hmac` varchar(255) NOT NULL,
  `ts` int(11) NOT NULL,
  PRIMARY KEY  (`hmac`),
  KEY `ts` (`ts`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_hmac_cache`
--

LOCK TABLES `elgg_hmac_cache` WRITE;
/*!40000 ALTER TABLE `elgg_hmac_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_hmac_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_metadata`
--

DROP TABLE IF EXISTS `elgg_metadata`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_metadata` (
  `id` int(11) NOT NULL auto_increment,
  `entity_guid` bigint(20) unsigned NOT NULL,
  `name_id` int(11) NOT NULL,
  `value_id` int(11) NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` bigint(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name_id` (`name_id`),
  KEY `value_id` (`value_id`),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_metadata`
--

LOCK TABLES `elgg_metadata` WRITE;
/*!40000 ALTER TABLE `elgg_metadata` DISABLE KEYS */;
INSERT INTO `elgg_metadata` VALUES (1,1,1,2,'text',2,2,1273686714,'yes'),(72,1,3,20,'text',2,2,1274357424,'yes'),(71,1,3,9,'text',2,2,1274357424,'yes'),(70,1,3,8,'text',2,2,1274357424,'yes'),(69,1,3,7,'text',2,2,1274357424,'yes'),(68,1,3,6,'text',2,2,1274357424,'yes'),(67,1,3,5,'text',2,2,1274357424,'yes'),(23,2,10,11,'text',0,2,1273686842,'yes'),(24,2,12,13,'text',0,2,1273686842,'yes'),(25,2,14,17,'text',2,2,1273686842,'yes'),(26,1,15,19,'text',2,2,1273686870,'yes'),(66,1,3,4,'text',2,2,1274357424,'yes');
/*!40000 ALTER TABLE `elgg_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_metastrings`
--

DROP TABLE IF EXISTS `elgg_metastrings`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_metastrings` (
  `id` int(11) NOT NULL auto_increment,
  `string` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `string` (`string`(50))
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_metastrings`
--

LOCK TABLES `elgg_metastrings` WRITE;
/*!40000 ALTER TABLE `elgg_metastrings` DISABLE KEYS */;
INSERT INTO `elgg_metastrings` VALUES (1,'email'),(2,''),(3,'enabled_plugins'),(4,'profile'),(5,'logbrowser'),(6,'diagnostics'),(7,'uservalidationbyemail'),(8,'htmlawed'),(9,'search'),(10,'validated'),(11,'1'),(12,'validated_method'),(13,'first_run'),(14,'notification:method:email'),(15,'pluginorder'),(16,'a:33:{i:10;s:10:\"categories\";i:20;s:12:\"custom_index\";i:30;s:4:\"file\";i:40;s:5:\"pages\";i:50;s:14:\"defaultwidgets\";i:60;s:5:\"embed\";i:70;s:8:\"htmlawed\";i:80;s:14:\"twitterservice\";i:90;s:7:\"friends\";i:100;s:11:\"diagnostics\";i:110;s:12:\"messageboard\";i:120;s:6:\"zaudio\";i:130;s:4:\"blog\";i:140;s:13:\"externalpages\";i:150;s:15:\"reportedcontent\";i:160;s:11:\"crontrigger\";i:170;s:7:\"thewire\";i:180;s:7:\"twitter\";i:190;s:8:\"messages\";i:200;s:6:\"search\";i:210;s:7:\"tinymce\";i:220;s:7:\"members\";i:230;s:6:\"groups\";i:240;s:9:\"logrotate\";i:250;s:14:\"riverdashboard\";i:260;s:10:\"logbrowser\";i:270;s:21:\"uservalidationbyemail\";i:280;s:9:\"bookmarks\";i:290;s:7:\"captcha\";i:300;s:13:\"invitefriends\";i:310;s:7:\"profile\";i:320;s:13:\"notifications\";i:330;s:16:\"garbagecollector\";}'),(17,'0'),(18,'a:34:{i:10;s:10:\"categories\";i:20;s:12:\"custom_index\";i:30;s:4:\"file\";i:40;s:5:\"pages\";i:50;s:14:\"defaultwidgets\";i:60;s:5:\"embed\";i:70;s:8:\"htmlawed\";i:80;s:14:\"twitterservice\";i:90;s:7:\"friends\";i:100;s:11:\"diagnostics\";i:110;s:12:\"messageboard\";i:120;s:6:\"zaudio\";i:130;s:4:\"blog\";i:140;s:13:\"externalpages\";i:150;s:15:\"reportedcontent\";i:160;s:11:\"crontrigger\";i:170;s:7:\"thewire\";i:180;s:7:\"twitter\";i:190;s:8:\"messages\";i:200;s:6:\"search\";i:210;s:7:\"tinymce\";i:220;s:7:\"members\";i:230;s:6:\"groups\";i:240;s:9:\"logrotate\";i:250;s:14:\"riverdashboard\";i:260;s:10:\"logbrowser\";i:270;s:21:\"uservalidationbyemail\";i:280;s:9:\"bookmarks\";i:290;s:7:\"captcha\";i:300;s:13:\"invitefriends\";i:310;s:7:\"profile\";i:320;s:13:\"notifications\";i:330;s:16:\"garbagecollector\";i:340;s:13:\"virtual_setup\";}'),(19,'a:34:{i:10;s:13:\"virtual_setup\";i:20;s:10:\"categories\";i:30;s:12:\"custom_index\";i:40;s:4:\"file\";i:50;s:5:\"pages\";i:60;s:14:\"defaultwidgets\";i:70;s:5:\"embed\";i:80;s:8:\"htmlawed\";i:90;s:14:\"twitterservice\";i:100;s:7:\"friends\";i:110;s:11:\"diagnostics\";i:120;s:12:\"messageboard\";i:130;s:6:\"zaudio\";i:140;s:4:\"blog\";i:150;s:13:\"externalpages\";i:160;s:15:\"reportedcontent\";i:170;s:11:\"crontrigger\";i:180;s:7:\"thewire\";i:190;s:7:\"twitter\";i:200;s:8:\"messages\";i:210;s:6:\"search\";i:220;s:7:\"tinymce\";i:230;s:7:\"members\";i:240;s:6:\"groups\";i:250;s:9:\"logrotate\";i:260;s:14:\"riverdashboard\";i:270;s:10:\"logbrowser\";i:280;s:21:\"uservalidationbyemail\";i:290;s:9:\"bookmarks\";i:300;s:7:\"captcha\";i:310;s:13:\"invitefriends\";i:320;s:7:\"profile\";i:330;s:13:\"notifications\";i:340;s:16:\"garbagecollector\";}'),(20,'virtual_setup');
/*!40000 ALTER TABLE `elgg_metastrings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_objects_entity`
--

DROP TABLE IF EXISTS `elgg_objects_entity`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_objects_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY  (`guid`),
  FULLTEXT KEY `title` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_objects_entity`
--

LOCK TABLES `elgg_objects_entity` WRITE;
/*!40000 ALTER TABLE `elgg_objects_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_objects_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_private_settings`
--

DROP TABLE IF EXISTS `elgg_private_settings`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_private_settings` (
  `id` int(11) NOT NULL auto_increment,
  `entity_guid` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `entity_guid` (`entity_guid`,`name`),
  KEY `name` (`name`),
  KEY `value` (`value`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_private_settings`
--

LOCK TABLES `elgg_private_settings` WRITE;
/*!40000 ALTER TABLE `elgg_private_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_private_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_river`
--

DROP TABLE IF EXISTS `elgg_river`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_river` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(8) NOT NULL,
  `subtype` varchar(32) NOT NULL,
  `action_type` varchar(32) NOT NULL,
  `access_id` int(11) NOT NULL,
  `view` text NOT NULL,
  `subject_guid` int(11) NOT NULL,
  `object_guid` int(11) NOT NULL,
  `annotation_id` int(11) NOT NULL,
  `posted` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `type` (`type`),
  KEY `action_type` (`action_type`),
  KEY `access_id` (`access_id`),
  KEY `subject_guid` (`subject_guid`),
  KEY `object_guid` (`object_guid`),
  KEY `annotation_id` (`annotation_id`),
  KEY `posted` (`posted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_river`
--

LOCK TABLES `elgg_river` WRITE;
/*!40000 ALTER TABLE `elgg_river` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_river` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_sites_entity`
--

DROP TABLE IF EXISTS `elgg_sites_entity`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_sites_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY  (`guid`),
  UNIQUE KEY `url` (`url`),
  FULLTEXT KEY `name` (`name`,`description`,`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_sites_entity`
--

LOCK TABLES `elgg_sites_entity` WRITE;
/*!40000 ALTER TABLE `elgg_sites_entity` DISABLE KEYS */;
INSERT INTO `elgg_sites_entity` VALUES (1,'Elgg','Elgg Virtual Appliance','http://192.168.1.94/');
/*!40000 ALTER TABLE `elgg_sites_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_system_log`
--

DROP TABLE IF EXISTS `elgg_system_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_system_log` (
  `id` int(11) NOT NULL auto_increment,
  `object_id` int(11) NOT NULL,
  `object_class` varchar(50) NOT NULL,
  `object_type` varchar(50) NOT NULL,
  `object_subtype` varchar(50) NOT NULL,
  `event` varchar(50) NOT NULL,
  `performed_by_guid` int(11) NOT NULL,
  `owner_guid` int(11) NOT NULL,
  `access_id` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL default 'yes',
  `time_created` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `object_id` (`object_id`),
  KEY `object_class` (`object_class`),
  KEY `object_type` (`object_type`),
  KEY `object_subtype` (`object_subtype`),
  KEY `event` (`event`),
  KEY `performed_by_guid` (`performed_by_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `river_key` (`object_type`,`object_subtype`,`event`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_system_log`
--

LOCK TABLES `elgg_system_log` WRITE;
/*!40000 ALTER TABLE `elgg_system_log` DISABLE KEYS */;
INSERT INTO `elgg_system_log` VALUES (1,1,'ElggMetadata','metadata','email','create',0,0,2,'yes',1273686714),(2,2,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(3,2,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(4,3,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(5,4,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(6,3,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(7,4,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(8,5,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(9,6,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(10,7,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(11,6,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(12,5,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(13,7,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(14,8,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(15,9,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(16,10,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(17,11,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(18,10,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(19,9,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(20,8,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(21,11,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(22,12,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(23,13,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(24,14,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(25,15,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(26,16,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(27,15,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(28,14,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(29,13,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(30,12,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(31,16,'ElggMetadata','metadata','enabled_plugins','delete',0,0,2,'yes',1273686714),(32,17,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(33,18,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(34,19,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(35,20,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(36,21,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(37,22,'ElggMetadata','metadata','enabled_plugins','create',0,0,2,'yes',1273686714),(38,1,'ElggRelationship','relationship','member_of_site','create',0,0,2,'yes',1273686842),(39,2,'ElggUser','user','','create',0,0,2,'yes',1273686842),(40,2,'ElggUser','user','','make_admin',0,0,2,'yes',1273686842),(41,23,'ElggMetadata','metadata','validated','create',0,0,2,'yes',1273686842),(42,24,'ElggMetadata','metadata','validated_method','create',0,0,2,'yes',1273686842),(43,25,'ElggMetadata','metadata','notification:method:email','create',0,0,2,'yes',1273686842),(44,2,'ElggUser','user','','update',2,0,2,'yes',1273686869),(45,2,'ElggUser','user','','login',2,0,2,'yes',1273686869),(46,26,'ElggMetadata','metadata','pluginorder','create',2,0,2,'yes',1273686870),(47,2,'ElggUser','user','','update',2,0,2,'yes',1274189099),(48,2,'ElggUser','user','','login',2,0,2,'yes',1274189099),(49,25,'ElggMetadata','metadata','notification:method:email','update',2,0,2,'yes',1274189645),(50,2,'ElggUser','user','','update',2,0,2,'yes',1274189645),(51,1,'ElggMetadata','metadata','email','update',2,0,2,'yes',1274189780),(52,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274189790),(53,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192484),(54,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192518),(55,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192518),(56,21,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(57,20,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(58,19,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(59,18,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(60,17,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(61,22,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192567),(62,27,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(63,28,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(64,29,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(65,30,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(66,31,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(67,32,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(68,33,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192567),(69,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192567),(70,2,'ElggUser','user','','update',2,0,2,'yes',1274192602),(71,2,'ElggUser','user','','login',2,0,2,'yes',1274192602),(72,1,'ElggMetadata','metadata','email','update',2,0,2,'yes',1274192602),(73,2,'ElggUser','user','','logout',2,0,2,'yes',1274192602),(74,32,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192602),(75,31,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192602),(76,30,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192602),(77,29,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192602),(78,28,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192603),(79,27,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192603),(80,33,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192603),(81,34,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(82,35,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(83,36,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(84,37,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(85,38,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(86,39,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192603),(87,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192603),(88,2,'ElggUser','user','','logout',2,0,2,'yes',1274192621),(89,2,'ElggUser','user','','update',2,0,2,'yes',1274192621),(90,2,'ElggUser','user','','update',2,0,2,'yes',1274192635),(91,2,'ElggUser','user','','login',2,0,2,'yes',1274192635),(92,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192643),(93,39,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(94,38,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(95,37,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(96,36,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(97,35,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(98,34,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192647),(99,40,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(100,41,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(101,42,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(102,43,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(103,44,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(104,45,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(105,46,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192647),(106,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192647),(107,2,'ElggUser','user','','logout',2,0,2,'yes',1274192660),(108,2,'ElggUser','user','','update',2,0,2,'yes',1274192660),(109,2,'ElggUser','user','','update',2,0,2,'yes',1274192677),(110,2,'ElggUser','user','','login',2,0,2,'yes',1274192677),(111,1,'ElggMetadata','metadata','email','update',2,0,2,'yes',1274192677),(112,2,'ElggUser','user','','logout',2,0,2,'yes',1274192677),(113,46,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(114,45,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(115,44,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(116,43,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(117,42,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(118,41,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(119,40,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192677),(120,47,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(121,48,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(122,49,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(123,50,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(124,51,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(125,52,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192677),(126,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192677),(127,52,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(128,51,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(129,50,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(130,49,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(131,48,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(132,47,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274192703),(133,53,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(134,54,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(135,55,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(136,56,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(137,57,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(138,58,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(139,59,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274192703),(140,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274192703),(141,2,'ElggUser','user','','logout',2,0,2,'yes',1274192720),(142,2,'ElggUser','user','','update',2,0,2,'yes',1274192720),(143,2,'ElggUser','user','','update',2,0,2,'yes',1274196634),(144,2,'ElggUser','user','','login',2,0,2,'yes',1274196634),(145,1,'ElggMetadata','metadata','email','update',2,0,2,'yes',1274196634),(146,2,'ElggUser','user','','logout',2,0,2,'yes',1274196634),(147,59,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(148,58,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(149,57,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(150,56,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(151,55,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(152,54,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(153,53,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274196634),(154,60,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(155,61,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(156,62,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(157,63,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(158,64,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(159,65,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274196634),(160,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274196634),(161,2,'ElggUser','user','','logout',2,0,2,'yes',1274196649),(162,2,'ElggUser','user','','update',2,0,2,'yes',1274196649),(163,2,'ElggUser','user','','update',2,0,2,'yes',1274196672),(164,2,'ElggUser','user','','login',2,0,2,'yes',1274196672),(165,2,'ElggUser','user','','update',2,0,2,'yes',1274357410),(166,2,'ElggUser','user','','login',2,0,2,'yes',1274357410),(167,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274357419),(168,65,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(169,64,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(170,63,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(171,62,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(172,61,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(173,60,'ElggMetadata','metadata','enabled_plugins','delete',2,0,2,'yes',1274357424),(174,66,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(175,67,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(176,68,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(177,69,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(178,70,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(179,71,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(180,72,'ElggMetadata','metadata','enabled_plugins','create',2,0,2,'yes',1274357424),(181,26,'ElggMetadata','metadata','pluginorder','update',2,0,2,'yes',1274357424);
/*!40000 ALTER TABLE `elgg_system_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_users_apisessions`
--

DROP TABLE IF EXISTS `elgg_users_apisessions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_users_apisessions` (
  `id` int(11) NOT NULL auto_increment,
  `user_guid` bigint(20) unsigned NOT NULL,
  `site_guid` bigint(20) unsigned NOT NULL,
  `token` varchar(40) default NULL,
  `expires` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user_guid` (`user_guid`,`site_guid`),
  KEY `token` (`token`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_users_apisessions`
--

LOCK TABLES `elgg_users_apisessions` WRITE;
/*!40000 ALTER TABLE `elgg_users_apisessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `elgg_users_apisessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_users_entity`
--

DROP TABLE IF EXISTS `elgg_users_entity`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_users_entity` (
  `guid` bigint(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `username` varchar(128) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `salt` varchar(8) NOT NULL default '',
  `email` text NOT NULL,
  `language` varchar(6) NOT NULL default '',
  `code` varchar(32) NOT NULL default '',
  `banned` enum('yes','no') NOT NULL default 'no',
  `admin` enum('yes','no') NOT NULL default 'no',
  `last_action` int(11) NOT NULL default '0',
  `prev_last_action` int(11) NOT NULL default '0',
  `last_login` int(11) NOT NULL default '0',
  `prev_last_login` int(11) NOT NULL default '0',
  PRIMARY KEY  (`guid`),
  UNIQUE KEY `username` (`username`),
  KEY `password` (`password`),
  KEY `email` (`email`(50)),
  KEY `code` (`code`),
  KEY `last_action` (`last_action`),
  KEY `last_login` (`last_login`),
  KEY `admin` (`admin`),
  FULLTEXT KEY `name` (`name`),
  FULLTEXT KEY `name_2` (`name`,`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_users_entity`
--

LOCK TABLES `elgg_users_entity` WRITE;
/*!40000 ALTER TABLE `elgg_users_entity` DISABLE KEYS */;
INSERT INTO `elgg_users_entity` VALUES (2,'admin','admin','d7f921410e3a86ad6119533d13fc4048','f80882b4','admin@localhost.net','en','','no','yes',1274357435,1274357424,1274357410,1274196672);
/*!40000 ALTER TABLE `elgg_users_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `elgg_users_sessions`
--

DROP TABLE IF EXISTS `elgg_users_sessions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `elgg_users_sessions` (
  `session` varchar(255) NOT NULL,
  `ts` int(11) unsigned NOT NULL default '0',
  `data` mediumblob,
  PRIMARY KEY  (`session`),
  KEY `ts` (`ts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `elgg_users_sessions`
--

LOCK TABLES `elgg_users_sessions` WRITE;
/*!40000 ALTER TABLE `elgg_users_sessions` DISABLE KEYS */;
INSERT INTO `elgg_users_sessions` VALUES ('289c22d7a2eec733d85b19c37186a23f',1273686843,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"b05dfb54fbe1db18cb9f1de37790f8be\";msg|a:0:{}view|s:7:\"default\";'),('786304d24d8ca225731c4acf2e44850f',1273686870,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"b05dfb54fbe1db18cb9f1de37790f8be\";msg|a:0:{}view|s:7:\"default\";user|O:8:\"ElggUser\":7:{s:13:\"\0*\0attributes\";a:25:{s:4:\"guid\";s:1:\"2\";s:4:\"type\";s:4:\"user\";s:7:\"subtype\";s:1:\"0\";s:10:\"owner_guid\";s:1:\"0\";s:14:\"container_guid\";s:1:\"0\";s:9:\"site_guid\";s:1:\"1\";s:9:\"access_id\";s:1:\"2\";s:12:\"time_created\";s:10:\"1273686842\";s:12:\"time_updated\";s:10:\"1273686869\";s:7:\"enabled\";s:3:\"yes\";s:12:\"tables_split\";i:2;s:13:\"tables_loaded\";i:2;s:4:\"name\";s:5:\"admin\";s:8:\"username\";s:5:\"admin\";s:8:\"password\";s:32:\"d7f921410e3a86ad6119533d13fc4048\";s:4:\"salt\";s:8:\"f80882b4\";s:5:\"email\";s:19:\"admin@localhost.net\";s:8:\"language\";s:0:\"\";s:4:\"code\";s:0:\"\";s:6:\"banned\";s:2:\"no\";s:5:\"admin\";s:3:\"yes\";s:11:\"last_action\";s:10:\"1273686869\";s:16:\"prev_last_action\";s:1:\"0\";s:10:\"last_login\";s:10:\"1273686869\";s:15:\"prev_last_login\";s:1:\"0\";}s:15:\"\0*\0url_override\";N;s:16:\"\0*\0icon_override\";N;s:16:\"\0*\0temp_metadata\";a:0:{}s:19:\"\0*\0temp_annotations\";a:0:{}s:11:\"\0*\0volatile\";a:0:{}s:17:\"\0ElggEntity\0valid\";b:0;}guid|s:1:\"2\";id|s:1:\"2\";username|s:5:\"admin\";name|s:5:\"admin\";'),('939b3a4df37f5a4cffcac876ff408d06',1273755630,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"6b2599c4a6a13db6d30d429c582f3d0a\";view|s:7:\"default\";msg|a:0:{}'),('02dff773ab33d973fb41563a900c1a2e',1274108570,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"e3ec1cdd785828d409f90a657969682d\";view|s:7:\"default\";msg|a:0:{}'),('1b3e34a29d8f2391605c6c0b233ae727',1274117000,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"81c1ba914060c033f8df1805e5b66e2c\";view|s:7:\"default\";msg|a:0:{}'),('9124a4f798d4d1713284bf88e7b39ee3',1274189090,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"63133123d8ad55a66b38dd04b6c8d8f2\";view|s:7:\"default\";msg|a:0:{}'),('0aa268e6210efb053d7b693da0b92155',1274192575,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"63133123d8ad55a66b38dd04b6c8d8f2\";view|s:7:\"default\";msg|a:0:{}user|O:8:\"ElggUser\":7:{s:13:\"\0*\0attributes\";a:25:{s:4:\"guid\";s:1:\"2\";s:4:\"type\";s:4:\"user\";s:7:\"subtype\";s:1:\"0\";s:10:\"owner_guid\";s:1:\"0\";s:14:\"container_guid\";s:1:\"0\";s:9:\"site_guid\";s:1:\"1\";s:9:\"access_id\";s:1:\"2\";s:12:\"time_created\";s:10:\"1273686842\";s:12:\"time_updated\";s:10:\"1274189645\";s:7:\"enabled\";s:3:\"yes\";s:12:\"tables_split\";i:2;s:13:\"tables_loaded\";i:2;s:4:\"name\";s:5:\"admin\";s:8:\"username\";s:5:\"admin\";s:8:\"password\";s:32:\"d7f921410e3a86ad6119533d13fc4048\";s:4:\"salt\";s:8:\"f80882b4\";s:5:\"email\";s:19:\"admin@localhost.net\";s:8:\"language\";s:2:\"en\";s:4:\"code\";s:0:\"\";s:6:\"banned\";s:2:\"no\";s:5:\"admin\";s:3:\"yes\";s:11:\"last_action\";s:10:\"1274192567\";s:16:\"prev_last_action\";s:10:\"1274192566\";s:10:\"last_login\";s:10:\"1274189099\";s:15:\"prev_last_login\";s:10:\"1273686869\";}s:15:\"\0*\0url_override\";N;s:16:\"\0*\0icon_override\";N;s:16:\"\0*\0temp_metadata\";a:0:{}s:19:\"\0*\0temp_annotations\";a:0:{}s:11:\"\0*\0volatile\";a:0:{}s:17:\"\0ElggEntity\0valid\";b:0;}guid|s:1:\"2\";id|s:1:\"2\";username|s:5:\"admin\";name|s:5:\"admin\";'),('f5f21630fd03397a5e5c5bf7277b7003',1274196673,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"819d2a412a926f762ef4ddee645d4cbc\";msg|a:0:{}view|s:7:\"default\";user|O:8:\"ElggUser\":7:{s:13:\"\0*\0attributes\";a:25:{s:4:\"guid\";s:1:\"2\";s:4:\"type\";s:4:\"user\";s:7:\"subtype\";s:1:\"0\";s:10:\"owner_guid\";s:1:\"0\";s:14:\"container_guid\";s:1:\"0\";s:9:\"site_guid\";s:1:\"1\";s:9:\"access_id\";s:1:\"2\";s:12:\"time_created\";s:10:\"1273686842\";s:12:\"time_updated\";s:10:\"1274196672\";s:7:\"enabled\";s:3:\"yes\";s:12:\"tables_split\";i:2;s:13:\"tables_loaded\";i:2;s:4:\"name\";s:5:\"admin\";s:8:\"username\";s:5:\"admin\";s:8:\"password\";s:32:\"d7f921410e3a86ad6119533d13fc4048\";s:4:\"salt\";s:8:\"f80882b4\";s:5:\"email\";s:19:\"admin@localhost.net\";s:8:\"language\";s:2:\"en\";s:4:\"code\";s:0:\"\";s:6:\"banned\";s:2:\"no\";s:5:\"admin\";s:3:\"yes\";s:11:\"last_action\";s:10:\"1274196672\";s:16:\"prev_last_action\";s:10:\"1274196649\";s:10:\"last_login\";s:10:\"1274196672\";s:15:\"prev_last_login\";s:10:\"1274196634\";}s:15:\"\0*\0url_override\";N;s:16:\"\0*\0icon_override\";N;s:16:\"\0*\0temp_metadata\";a:0:{}s:19:\"\0*\0temp_annotations\";a:0:{}s:11:\"\0*\0volatile\";a:0:{}s:17:\"\0ElggEntity\0valid\";b:0;}guid|s:1:\"2\";id|s:1:\"2\";username|s:5:\"admin\";name|s:5:\"admin\";'),('6477e487579c3a4b14727cd10f24889b',1274192621,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"9b82056552de7d89152802b9f7c21729\";msg|a:0:{}view|s:7:\"default\";'),('f9f33e81890e071f0f2869e900a11238',1274192660,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"c6f6fab34a3ead4314806841b6b0c832\";msg|a:0:{}view|s:7:\"default\";'),('51e9b72c39419f65f02b96bfc53a2c26',1274192827,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"ac7dfc57fe681b1f15f45b70d39e3f52\";msg|a:0:{}view|s:7:\"default\";'),('829bf96bb866853b5663a379b0055304',1274196628,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"ea37a6b32f1f148213c8cd4a46a6ccb9\";view|s:7:\"default\";msg|a:0:{}'),('fa5620818b416171ef17ed23231ae3d6',1274196665,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"819d2a412a926f762ef4ddee645d4cbc\";msg|a:0:{}view|s:7:\"default\";'),('fd423250972621dd0d3875b48eacd5c5',1274357395,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"6792caba8c64ac5897415be5599a2535\";view|s:7:\"default\";msg|a:0:{}'),('afefd387424b56e6cf5f313fd2b494a9',1274357435,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"6792caba8c64ac5897415be5599a2535\";view|s:7:\"default\";msg|a:0:{}user|O:8:\"ElggUser\":7:{s:13:\"\0*\0attributes\";a:25:{s:4:\"guid\";s:1:\"2\";s:4:\"type\";s:4:\"user\";s:7:\"subtype\";s:1:\"0\";s:10:\"owner_guid\";s:1:\"0\";s:14:\"container_guid\";s:1:\"0\";s:9:\"site_guid\";s:1:\"1\";s:9:\"access_id\";s:1:\"2\";s:12:\"time_created\";s:10:\"1273686842\";s:12:\"time_updated\";s:10:\"1274357410\";s:7:\"enabled\";s:3:\"yes\";s:12:\"tables_split\";i:2;s:13:\"tables_loaded\";i:2;s:4:\"name\";s:5:\"admin\";s:8:\"username\";s:5:\"admin\";s:8:\"password\";s:32:\"d7f921410e3a86ad6119533d13fc4048\";s:4:\"salt\";s:8:\"f80882b4\";s:5:\"email\";s:19:\"admin@localhost.net\";s:8:\"language\";s:2:\"en\";s:4:\"code\";s:0:\"\";s:6:\"banned\";s:2:\"no\";s:5:\"admin\";s:3:\"yes\";s:11:\"last_action\";s:10:\"1274357424\";s:16:\"prev_last_action\";s:10:\"1274357424\";s:10:\"last_login\";s:10:\"1274357410\";s:15:\"prev_last_login\";s:10:\"1274196672\";}s:15:\"\0*\0url_override\";N;s:16:\"\0*\0icon_override\";N;s:16:\"\0*\0temp_metadata\";a:0:{}s:19:\"\0*\0temp_annotations\";a:0:{}s:11:\"\0*\0volatile\";a:0:{}s:17:\"\0ElggEntity\0valid\";b:0;}guid|s:1:\"2\";id|s:1:\"2\";username|s:5:\"admin\";name|s:5:\"admin\";'),('18494cbed40244db163729ea9b5c967b',1274378155,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"1e755fd6dd7a76ce722fc61184ba521c\";view|s:7:\"default\";msg|a:0:{}'),('504c8ba6678f893cae2f130b7b330db4',1274379684,'__elgg_fingerprint|s:32:\"6c98154d86ea779cd625cd7011b8fed5\";__elgg_session|s:32:\"0d925ddaba11333fd03d79ddbaa3599c\";view|s:7:\"default\";msg|a:0:{}');
/*!40000 ALTER TABLE `elgg_users_sessions` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
CREATE USER 'elgg'@'localhost' IDENTIFIED BY 'elgg';
GRANT ALL ON elgg.* TO 'elgg'@'localhost' IDENTIFIED BY 'elgg';
-- Dump completed on 2010-05-20 18:23:00
