#!/usr/bin/python
"""Set Jenkins admin password and email

Option:
    --pass=     unless provided, will ask interactively
    --email=    unless provided, will ask interactively

"""

import sys
import getopt
import hashlib
import string
import random
import fileinput

from dialog_wrapper import Dialog

def usage(s=None):
    if s:
        print >> sys.stderr, "Error:", s
    print >> sys.stderr, "Syntax: %s [options]" % sys.argv[0]
    print >> sys.stderr, __doc__
    sys.exit(1)

def main():
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "h",
                                       ['help', 'pass=', 'email='])
    except getopt.GetoptError, e:
        usage(e)

    password = ""
    email = ""
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt == '--pass':
            password = val
        elif opt == '--email':
            email = val

    if not password:
        d = Dialog('TurnKey Linux - First boot configuration')
        password = d.get_password(
            "Jenkins Password",
            "Enter new password for the Jenkins 'admin' account.")

    if not email:
        if 'd' not in locals():
            d = Dialog('TurnKey Linux - First boot configuration')

        email = d.get_email(
            "Jenkins Email",
            "Enter email address for the Jenkins 'admin' account.",
            "admin@example.com")
    
    salt = ''.join((random.choice(string.letters+string.digits) for x in range(6)))
    hashpass = hashlib.sha256(password+"{"+salt+"}").hexdigest()
    salthash = salt+":"+hashpass

    for line in fileinput.input("/var/lib/jenkins/users/admin/config.xml",inplace=True):
        line = line.replace("tkladminpass", salthash)
        line = line.replace("tkladminemail", email)
        sys.stdout.write(line)

if __name__ == "__main__":
    main()

