#!/usr/bin/python
"""Set OJS admin password

Option:
    --pass=     unless provided, will ask interactively
    --email=    unless provided, will ask interactively

"""

import string
import sys
import getopt
import hashlib
import random

from dialog_wrapper import Dialog
from mysqlconf import MySQL

def usage(s=None):
    if s:
        print >> sys.stderr, "Error:", s
    print >> sys.stderr, "Syntax: %s [options]" % sys.argv[0]
    print >> sys.stderr, __doc__
    sys.exit(1)

salt = "admin"

def _get_hashpass(password):
    hash = hashlib.sha1(salt + password).hexdigest()
    return hash
    
def main():
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "h",
                                       ['help', 'pass=', 'email='])
    except getopt.GetoptError, e:
        usage(e)

    password = ""
    email = ""
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt == '--pass':
            password = val
        elif opt == '--email':
            email = val

    if not password:
        d = Dialog('TurnKey Linux - First boot configuration')
        password = d.get_password(
            "Open Journal System Password",
            "Enter new password for the OJS 'admin' account.")

#    if not email:
#        if 'd' not in locals():
#            d = Dialog('TurnKey Linux - First boot configuration')

#        email = d.get_email(
#            "Omeka Email",
#            "Enter email address for the Omeka 'admin' account.",
#            "admin@example.com")
    
    hash = _get_hashpass(password)

    m = MySQL()
    m.execute('UPDATE ojs.users SET password=\"%s\" WHERE username=\"admin\";' % hash)
if __name__ == "__main__":
    main()

