#!/usr/bin/python
"""Set Django admin password and email

Option:
    --pass=     unless provided, will ask interactively
    --email=    unless provided, will ask interactively

"""

import string
import sys
import getopt
import hashlib
import random

from dialog_wrapper import Dialog
from mysqlconf import MySQL

def usage(s=None):
    if s:
        print >> sys.stderr, "Error:", s
    print >> sys.stderr, "Syntax: %s [options]" % sys.argv[0]
    print >> sys.stderr, __doc__
    sys.exit(1)

salt = "".join(random.choice(string.letters) for line in range(16))

def _get_hashpass(password):
    hash = hashlib.sha1(salt + password).hexdigest()
    return hash
    
def main():
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "h",
                                       ['help', 'pass=', 'email='])
    except getopt.GetoptError, e:
        usage(e)

    password = ""
    email = ""
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt == '--pass':
            password = val
        elif opt == '--email':
            email = val

    if not password:
        d = Dialog('TurnKey Linux - First boot configuration')
        password = d.get_password(
            "Omeka Password",
            "Enter new password for the Omeka 'admin' account.")

    if not email:
        if 'd' not in locals():
            d = Dialog('TurnKey Linux - First boot configuration')

        email = d.get_email(
            "Omeka Email",
            "Enter email address for the Omeka 'admin' account.",
            "admin@example.com")
    
    hashpass = _get_hashpass(password)

    m = MySQL()
    m.execute('UPDATE omeka.omeka_options SET value=\"%s\" WHERE name=\"administrator_email\";' % email)
    m.execute('UPDATE omeka.omeka_users SET password=\"%s\" WHERE username=\"admin\";' % hashpass)
    m.execute('UPDATE omeka.omeka_users SET salt=\"%s\" WHERE username=\"admin\";' % salt)
if __name__ == "__main__":
    main()

