-- phpMyAdmin SQL Dump
-- version 3.3.2deb1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Jan 23, 2011 at 02:38 PM
-- Server version: 5.1.41
-- PHP Version: 5.3.2-1ubuntu4.5

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `omeka`
--
CREATE DATABASE `omeka` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
USE `omeka`;

-- --------------------------------------------------------

--
-- Table structure for table `omeka_collections`
--

CREATE TABLE IF NOT EXISTS `omeka_collections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `collectors` text COLLATE utf8_unicode_ci NOT NULL,
  `public` tinyint(1) NOT NULL,
  `featured` tinyint(1) NOT NULL,
  `added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `public` (`public`),
  KEY `featured` (`featured`),
  KEY `owner_id` (`owner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_collections`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_data_types`
--

CREATE TABLE IF NOT EXISTS `omeka_data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `omeka_data_types`
--

INSERT INTO `omeka_data_types` (`id`, `name`, `description`) VALUES
(1, 'Text', 'A long, typically multi-line text string. Up to 65535 characters.'),
(2, 'Tiny Text', 'A short, typically one-line text string. Up to 255 characters.'),
(3, 'Date Range', 'A date range, begin to end. In format yyyy-mm-dd yyyy-mm-dd.'),
(4, 'Integer', 'Set of numbers consisting of the natural numbers including 0 (0, 1, 2, 3, ...) and their negatives (0, âˆ’1, âˆ’2, âˆ’3, ...).'),
(9, 'Date', 'A date in format yyyy-mm-dd'),
(10, 'Date Time', 'A date and time combination in the format: yyyy-mm-dd hh:mm:ss');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_element_sets`
--

CREATE TABLE IF NOT EXISTS `omeka_element_sets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `record_type_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `record_type_id` (`record_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `omeka_element_sets`
--

INSERT INTO `omeka_element_sets` (`id`, `record_type_id`, `name`, `description`) VALUES
(1, 1, 'Dublin Core', 'The Dublin Core metadata element set. These elements are common to all Omeka resources, including items, files, collections, exhibits, and entities. See http://dublincore.org/documents/dces/.'),
(3, 2, 'Item Type Metadata', 'The item type metadata element set, consisting of all item type elements bundled with Omeka and all item type elements created by an administrator.'),
(4, 3, 'Omeka Legacy File', 'The metadata element set that, in addition to the Dublin Core element set, was included in the `files` table in previous versions of Omeka. These elements are common to all Omeka files. This set may be deprecated in future versions.'),
(5, 3, 'Omeka Image File', 'The metadata element set that was included in the `files_images` table in previous versions of Omeka. These elements are common to all image files.'),
(6, 3, 'Omeka Video File', 'The metadata element set that was included in the `files_videos` table in previous versions of Omeka. These elements are common to all video files.');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_element_texts`
--

CREATE TABLE IF NOT EXISTS `omeka_element_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `record_id` int(10) unsigned NOT NULL,
  `record_type_id` int(10) unsigned NOT NULL,
  `element_id` int(10) unsigned NOT NULL,
  `html` tinyint(1) NOT NULL,
  `text` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `record_id` (`record_id`),
  KEY `record_type_id` (`record_type_id`),
  KEY `element_id` (`element_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_element_texts`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_elements`
--

CREATE TABLE IF NOT EXISTS `omeka_elements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `record_type_id` int(10) unsigned NOT NULL,
  `data_type_id` int(10) unsigned NOT NULL,
  `element_set_id` int(10) unsigned NOT NULL,
  `order` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_element_set_id` (`element_set_id`,`name`),
  UNIQUE KEY `order_element_set_id` (`element_set_id`,`order`),
  KEY `record_type_id` (`record_type_id`),
  KEY `data_type_id` (`data_type_id`),
  KEY `element_set_id` (`element_set_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=86 ;

--
-- Dumping data for table `omeka_elements`
--

INSERT INTO `omeka_elements` (`id`, `record_type_id`, `data_type_id`, `element_set_id`, `order`, `name`, `description`) VALUES
(1, 2, 1, 3, NULL, 'Text', 'Any textual data included in the document.'),
(2, 2, 2, 3, NULL, 'Interviewer', 'The person(s) performing the interview.'),
(3, 2, 2, 3, NULL, 'Interviewee', 'The person(s) being interviewed.'),
(4, 2, 2, 3, NULL, 'Location', 'The location of the interview.'),
(5, 2, 1, 3, NULL, 'Transcription', 'Any written text transcribed from a sound.'),
(6, 2, 2, 3, NULL, 'Local URL', 'The URL of the local directory containing all assets of the website.'),
(7, 2, 2, 3, NULL, 'Original Format', 'If the image is of an object, state the type of object, such as painting, sculpture, paper, photo, and additional data'),
(10, 2, 2, 3, NULL, 'Physical Dimensions', 'The actual physical size of the original image.'),
(11, 2, 2, 3, NULL, 'Duration', 'Length of time involved (seconds, minutes, hours, days, class periods, etc.)'),
(12, 2, 2, 3, NULL, 'Compression', 'Type/rate of compression for moving image file (i.e. MPEG-4)'),
(13, 2, 2, 3, NULL, 'Producer', 'Name (or names) of the person who produced the video.'),
(14, 2, 2, 3, NULL, 'Director', 'Name (or names) of the person who produced the video.'),
(15, 2, 2, 3, NULL, 'Bit Rate/Frequency', 'Rate at which bits are transferred (i.e. 96 kbit/s would be FM quality audio)'),
(16, 2, 2, 3, NULL, 'Time Summary', 'A summary of an interview given for different time stamps throughout the interview'),
(17, 2, 1, 3, NULL, 'Email Body', 'The main body of the email, including all replied and forwarded text and headers.'),
(18, 2, 2, 3, NULL, 'Subject Line', 'The content of the subject line of the email.'),
(19, 2, 2, 3, NULL, 'From', 'The name and email address of the person sending the email.'),
(20, 2, 2, 3, NULL, 'To', 'The name(s) and email address(es) of the person to whom the email was sent.'),
(21, 2, 2, 3, NULL, 'CC', 'The name(s) and email address(es) of the person to whom the email was carbon copied.'),
(22, 2, 2, 3, NULL, 'BCC', 'The name(s) and email address(es) of the person to whom the email was blind carbon copied.'),
(23, 2, 2, 3, NULL, 'Number of Attachments', 'The number of attachments to the email.'),
(24, 2, 1, 3, NULL, 'Standards', ''),
(25, 2, 1, 3, NULL, 'Objectives', ''),
(26, 2, 1, 3, NULL, 'Materials', ''),
(27, 2, 1, 3, NULL, 'Lesson Plan Text', ''),
(28, 2, 2, 3, NULL, 'URL', ''),
(29, 2, 2, 3, NULL, 'Event Type', ''),
(30, 2, 1, 3, NULL, 'Participants', 'Names of individuals or groups participating in the event.'),
(31, 2, 9, 3, NULL, 'Birth Date', ''),
(32, 2, 2, 3, NULL, 'Birthplace', ''),
(33, 2, 9, 3, NULL, 'Death Date', ''),
(34, 2, 2, 3, NULL, 'Occupation', ''),
(35, 2, 1, 3, NULL, 'Biographical Text', ''),
(36, 2, 1, 3, NULL, 'Bibliography', ''),
(37, 1, 2, 1, 8, 'Contributor', 'An entity responsible for making contributions to the resource. Examples of a Contributor include a person, an organization, or a service. Typically, the name of a Contributor should be used to indicate the entity.'),
(38, 1, 2, 1, 15, 'Coverage', 'The spatial or temporal topic of the resource, the spatial applicability of the resource, or the jurisdiction under which the resource is relevant. Spatial topic and spatial applicability may be a named place or a location specified by its geographic coordinates. Temporal topic may be a named period, date, or date range. A jurisdiction may be a named administrative entity or a geographic place to which the resource applies. Recommended best practice is to use a controlled vocabulary such as the Thesaurus of Geographic Names [TGN]. Where appropriate, named places or time periods can be used in preference to numeric identifiers such as sets of coordinates or date ranges.'),
(39, 1, 2, 1, 4, 'Creator', 'An entity primarily responsible for making the resource. Examples of a Creator include a person, an organization, or a service. Typically, the name of a Creator should be used to indicate the entity.'),
(40, 1, 2, 1, 7, 'Date', 'A point or period of time associated with an event in the lifecycle of the resource. Date may be used to express temporal information at any level of granularity. Recommended best practice is to use an encoding scheme, such as the W3CDTF profile of ISO 8601 [W3CDTF].'),
(41, 1, 1, 1, 3, 'Description', 'An account of the resource. Description may include but is not limited to: an abstract, a table of contents, a graphical representation, or a free-text account of the resource.'),
(42, 1, 2, 1, 11, 'Format', 'The file format, physical medium, or dimensions of the resource. Examples of dimensions include size and duration. Recommended best practice is to use a controlled vocabulary such as the list of Internet Media Types [MIME].'),
(43, 1, 2, 1, 14, 'Identifier', 'An unambiguous reference to the resource within a given context. Recommended best practice is to identify the resource by means of a string conforming to a formal identification system.'),
(44, 1, 2, 1, 12, 'Language', 'A language of the resource. Recommended best practice is to use a controlled vocabulary such as RFC 4646 [RFC4646].'),
(45, 1, 2, 1, 6, 'Publisher', 'An entity responsible for making the resource available. Examples of a Publisher include a person, an organization, or a service. Typically, the name of a Publisher should be used to indicate the entity.'),
(46, 1, 2, 1, 10, 'Relation', 'A related resource. Recommended best practice is to identify the related resource by means of a string conforming to a formal identification system.'),
(47, 1, 2, 1, 9, 'Rights', 'Information about rights held in and over the resource. Typically, rights information includes a statement about various property rights associated with the resource, including intellectual property rights.'),
(48, 1, 2, 1, 5, 'Source', 'A related resource from which the described resource is derived. The described resource may be derived from the related resource in whole or in part. Recommended best practice is to identify the related resource by means of a string conforming to a formal identification system.'),
(49, 1, 2, 1, 2, 'Subject', 'The topic of the resource. Typically, the subject will be represented using keywords, key phrases, or classification codes. Recommended best practice is to use a controlled vocabulary. To describe the spatial or temporal topic of the resource, use the Coverage element.'),
(50, 1, 2, 1, 1, 'Title', 'A name given to the resource. Typically, a Title will be a name by which the resource is formally known.'),
(51, 1, 2, 1, 13, 'Type', 'The nature or genre of the resource. Recommended best practice is to use a controlled vocabulary such as the DCMI Type Vocabulary [DCMITYPE]. To describe the file format, physical medium, or dimensions of the resource, use the Format element.'),
(58, 3, 1, 4, 1, 'Additional Creator', ''),
(59, 3, 1, 4, 2, 'Transcriber', ''),
(60, 3, 1, 4, 3, 'Producer', ''),
(61, 3, 1, 4, 4, 'Render Device', ''),
(62, 3, 1, 4, 5, 'Render Details', ''),
(63, 3, 10, 4, 6, 'Capture Date', ''),
(64, 3, 1, 4, 7, 'Capture Device', ''),
(65, 3, 1, 4, 8, 'Capture Details', ''),
(66, 3, 1, 4, 9, 'Change History', ''),
(67, 3, 1, 4, 10, 'Watermark', ''),
(69, 3, 1, 4, 12, 'Encryption', ''),
(70, 3, 1, 4, 13, 'Compression', ''),
(71, 3, 1, 4, 14, 'Post Processing', ''),
(72, 3, 4, 5, 1, 'Width', ''),
(73, 3, 4, 5, 2, 'Height', ''),
(74, 3, 4, 5, 3, 'Bit Depth', ''),
(75, 3, 4, 5, 4, 'Channels', ''),
(76, 3, 1, 5, 5, 'Exif String', ''),
(77, 3, 1, 5, 6, 'Exif Array', ''),
(78, 3, 1, 5, 7, 'IPTC String', ''),
(79, 3, 1, 5, 8, 'IPTC Array', ''),
(80, 3, 4, 6, 1, 'Bitrate', ''),
(81, 3, 4, 6, 2, 'Duration', ''),
(82, 3, 4, 6, 3, 'Sample Rate', ''),
(83, 3, 1, 6, 4, 'Codec', ''),
(84, 3, 4, 6, 5, 'Width', ''),
(85, 3, 4, 6, 6, 'Height', '');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_entities`
--

CREATE TABLE IF NOT EXISTS `omeka_entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` text COLLATE utf8_unicode_ci,
  `middle_name` text COLLATE utf8_unicode_ci,
  `last_name` text COLLATE utf8_unicode_ci,
  `email` text COLLATE utf8_unicode_ci,
  `institution` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `omeka_entities`
--

INSERT INTO `omeka_entities` (`id`, `first_name`, `middle_name`, `last_name`, `email`, `institution`) VALUES
(1, 'Super', NULL, 'User', 'address@example.com', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `omeka_entities_relations`
--

CREATE TABLE IF NOT EXISTS `omeka_entities_relations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `relation_id` int(10) unsigned DEFAULT NULL,
  `relationship_id` int(10) unsigned DEFAULT NULL,
  `type` enum('Item','Collection','Exhibit') COLLATE utf8_unicode_ci NOT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `relation_type` (`type`),
  KEY `relation` (`relation_id`),
  KEY `relationship` (`relationship_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_entities_relations`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_entity_relationships`
--

CREATE TABLE IF NOT EXISTS `omeka_entity_relationships` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `omeka_entity_relationships`
--

INSERT INTO `omeka_entity_relationships` (`id`, `name`, `description`) VALUES
(1, 'added', NULL),
(2, 'modified', NULL),
(3, 'favorite', NULL),
(4, 'collector', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `omeka_files`
--

CREATE TABLE IF NOT EXISTS `omeka_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(10) unsigned NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `has_derivative_image` tinyint(1) NOT NULL,
  `authentication` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mime_browser` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mime_os` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type_os` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `archive_filename` text COLLATE utf8_unicode_ci NOT NULL,
  `original_filename` text COLLATE utf8_unicode_ci NOT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_files`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_item_types`
--

CREATE TABLE IF NOT EXISTS `omeka_item_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=14 ;

--
-- Dumping data for table `omeka_item_types`
--

INSERT INTO `omeka_item_types` (`id`, `name`, `description`) VALUES
(1, 'Document', 'A resource containing textual data.  Note that facsimiles or images of texts are still of the genre text.'),
(3, 'Moving Image', 'A series of visual representations that, when shown in succession, impart an impression of motion.'),
(4, 'Oral History', 'A resource containing historical information obtained in interviews with persons having firsthand knowledge.'),
(5, 'Sound', 'A resource whose content is primarily intended to be rendered as audio.'),
(6, 'Still Image', 'A static visual representation. Examples of still images are: paintings, drawings, graphic designs, plans and maps.  Recommended best practice is to assign the type "text" to images of textual materials.'),
(7, 'Website', 'A resource comprising of a web page or web pages and all related assets ( such as images, sound and video files, etc. ).'),
(8, 'Event', 'A non-persistent, time-based occurrence.  Metadata for an event provides descriptive information that is the basis for discovery of the purpose, location, duration, and responsible agents associated with an event. Examples include an exhibition, webcast, conference, workshop, open day, performance, battle, trial, wedding, tea party, conflagration.'),
(9, 'Email', 'A resource containing textual messages and binary attachments sent electronically from one person to another or one person to many people.'),
(10, 'Lesson Plan', 'Instructional materials.'),
(11, 'Hyperlink', 'Title, URL, Description or annotation.'),
(12, 'Person', 'An individual, biographical data, birth and death, etc.'),
(13, 'Interactive Resource', 'A resource requiring interaction from the user to be understood, executed, or experienced. Examples include forms on Web pages, applets, multimedia learning objects, chat services, or virtual reality environments.');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_item_types_elements`
--

CREATE TABLE IF NOT EXISTS `omeka_item_types_elements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_type_id` int(10) unsigned NOT NULL,
  `element_id` int(10) unsigned NOT NULL,
  `order` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_type_id_element_id` (`item_type_id`,`element_id`),
  KEY `item_type_id` (`item_type_id`),
  KEY `element_id` (`element_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=48 ;

--
-- Dumping data for table `omeka_item_types_elements`
--

INSERT INTO `omeka_item_types_elements` (`id`, `item_type_id`, `element_id`, `order`) VALUES
(1, 1, 7, NULL),
(2, 1, 1, NULL),
(3, 6, 7, NULL),
(6, 6, 10, NULL),
(7, 3, 7, NULL),
(8, 3, 11, NULL),
(9, 3, 12, NULL),
(10, 3, 13, NULL),
(11, 3, 14, NULL),
(12, 3, 5, NULL),
(13, 5, 7, NULL),
(14, 5, 11, NULL),
(15, 5, 15, NULL),
(16, 5, 5, NULL),
(17, 4, 7, NULL),
(18, 4, 11, NULL),
(19, 4, 15, NULL),
(20, 4, 5, NULL),
(21, 4, 2, NULL),
(22, 4, 3, NULL),
(23, 4, 4, NULL),
(24, 4, 16, NULL),
(25, 9, 17, NULL),
(26, 9, 18, NULL),
(27, 9, 20, NULL),
(28, 9, 19, NULL),
(29, 9, 21, NULL),
(30, 9, 22, NULL),
(31, 9, 23, NULL),
(32, 10, 24, NULL),
(33, 10, 25, NULL),
(34, 10, 26, NULL),
(35, 10, 11, NULL),
(36, 10, 27, NULL),
(37, 7, 6, NULL),
(38, 11, 28, NULL),
(39, 8, 29, NULL),
(40, 8, 30, NULL),
(41, 8, 11, NULL),
(42, 12, 31, NULL),
(43, 12, 32, NULL),
(44, 12, 33, NULL),
(45, 12, 34, NULL),
(46, 12, 35, NULL),
(47, 12, 36, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `omeka_items`
--

CREATE TABLE IF NOT EXISTS `omeka_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_type_id` int(10) unsigned DEFAULT NULL,
  `collection_id` int(10) unsigned DEFAULT NULL,
  `featured` tinyint(1) NOT NULL,
  `public` tinyint(1) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `item_type_id` (`item_type_id`),
  KEY `collection_id` (`collection_id`),
  KEY `public` (`public`),
  KEY `featured` (`featured`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_items`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_mime_element_set_lookup`
--

CREATE TABLE IF NOT EXISTS `omeka_mime_element_set_lookup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `element_set_id` int(10) unsigned NOT NULL,
  `mime` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mime` (`mime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=35 ;

--
-- Dumping data for table `omeka_mime_element_set_lookup`
--

INSERT INTO `omeka_mime_element_set_lookup` (`id`, `element_set_id`, `mime`) VALUES
(1, 5, 'image/bmp'),
(2, 5, 'image/gif'),
(3, 5, 'image/ief'),
(4, 5, 'image/jpeg'),
(5, 5, 'image/pict'),
(6, 5, 'image/pjpeg'),
(7, 5, 'image/png'),
(8, 5, 'image/tiff'),
(9, 5, 'image/vnd.rn-realflash'),
(10, 5, 'image/vnd.rn-realpix'),
(11, 5, 'image/vnd.wap.wbmp'),
(12, 5, 'image/x-icon'),
(13, 5, 'image/x-jg'),
(14, 5, 'image/x-jps'),
(15, 5, 'image/x-niff'),
(16, 5, 'image/x-pcx'),
(17, 5, 'image/x-pict'),
(18, 5, 'image/x-quicktime'),
(19, 5, 'image/x-rgb'),
(20, 5, 'image/x-tiff'),
(21, 5, 'image/x-windows-bmp'),
(22, 5, 'image/x-xbitmap'),
(23, 5, 'image/x-xbm'),
(24, 5, 'image/x-xpixmap'),
(25, 5, 'image/x-xwd'),
(26, 5, 'image/x-xwindowdump'),
(27, 6, 'video/x-msvideo'),
(28, 6, 'video/avi'),
(29, 6, 'video/msvideo'),
(30, 6, 'video/x-mpeg'),
(31, 6, 'video/x-ms-asf'),
(32, 6, 'video/mpeg'),
(33, 6, 'video/quicktime'),
(34, 6, 'video/x-ms-wmv');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_options`
--

CREATE TABLE IF NOT EXISTS `omeka_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `omeka_options`
--

INSERT INTO `omeka_options` (`id`, `name`, `value`) VALUES
(1, 'omeka_version', '1.3.1'),
(2, 'administrator_email', ''),
(3, 'copyright', ''),
(4, 'site_title', 'omeka'),
(5, 'author', ''),
(6, 'description', ''),
(7, 'thumbnail_constraint', '200'),
(8, 'square_thumbnail_constraint', '200'),
(9, 'fullsize_constraint', '800'),
(10, 'per_page_admin', '10'),
(11, 'per_page_public', '10'),
(12, 'show_empty_elements', '0'),
(13, 'path_to_convert', '/usr/bin'),
(14, 'admin_theme', 'default'),
(15, 'public_theme', 'default'),
(16, 'file_extension_whitelist', 'aac,aif,aiff,asf,asx,avi,bmp,c,cc,class,css,divx,doc,docx,exe,gif,gz,gzip,h,ico,j2k,jp2,jpe,jpeg,jpg,m4a,mdb,mid,midi,mov,mp2,mp3,mp4,mpa,mpe,mpeg,mpg,mpp,odb,odc,odf,odg,odp,ods,odt,ogg, pdf,png,pot,pps,ppt,pptx,qt,ra,ram,rtf,rtx,swf,tar,tif,tiff,txt, wav,wax,wma,wmv,wmx,wri,xla,xls,xlsx,xlt,xlw,zip'),
(17, 'file_mime_type_whitelist', 'application/msword,application/ogg,application/pdf,application/rtf,application/vnd.ms-access,application/vnd.ms-excel,application/vnd.ms-powerpoint,application/vnd.ms-project,application/vnd.ms-write,application/vnd.oasis.opendocument.chart,application/vnd.oasis.opendocument.database,application/vnd.oasis.opendocument.formula,application/vnd.oasis.opendocument.graphics,application/vnd.oasis.opendocument.presentation,application/vnd.oasis.opendocument.spreadsheet,application/vnd.oasis.opendocument.text,application/x-ms-wmp,application/x-ogg,application/x-gzip,application/x-msdownload,application/x-shockwave-flash,application/x-tar,application/zip,audio/aac,audio/aiff,audio/mid,audio/midi,audio/mp3,audio/mp4,audio/mpeg,audio/mpeg3,audio/ogg,audio/wav,audio/wma,audio/x-aac,audio/x-aiff,audio/x-midi,audio/x-mp3,audio/x-mp4,audio/x-mpeg,audio/x-mpeg3,audio/x-mpegaudio,audio/x-ms-wax,audio/x-realaudio,audio/x-wav,audio/x-wma,image/bmp,image/gif,image/icon,image/jpeg,image/pjpeg,image/png,image/tiff,image/x-icon,image/x-ms-bmp,text/css,text/plain,text/richtext,video/asf,video/avi,video/divx,video/mp4,video/mpeg,video/msvideo,video/ogg,video/quicktime,video/x-ms-wmv,video/x-msvideo'),
(18, 'disable_default_file_validation', ''),
(19, 'enable_header_check_for_file_mime_types', '');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_plugins`
--

CREATE TABLE IF NOT EXISTS `omeka_plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `version` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `active_idx` (`active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_plugins`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_processes`
--

CREATE TABLE IF NOT EXISTS `omeka_processes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `pid` int(10) unsigned DEFAULT NULL,
  `status` enum('starting','in progress','completed','paused','error','stopped') COLLATE utf8_unicode_ci NOT NULL,
  `args` text COLLATE utf8_unicode_ci NOT NULL,
  `started` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `stopped` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `pid` (`pid`),
  KEY `started` (`started`),
  KEY `stopped` (`stopped`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_processes`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_record_types`
--

CREATE TABLE IF NOT EXISTS `omeka_record_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `omeka_record_types`
--

INSERT INTO `omeka_record_types` (`id`, `name`, `description`) VALUES
(1, 'All', 'Elements, element sets, and element texts assigned to this record type relate to all possible records.'),
(2, 'Item', 'Elements, element sets, and element texts assigned to this record type relate to item records.'),
(3, 'File', 'Elements, element sets, and element texts assigned to this record type relate to file records.');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_schema_migrations`
--

CREATE TABLE IF NOT EXISTS `omeka_schema_migrations` (
  `version` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `unique_schema_migrations` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `omeka_schema_migrations`
--

INSERT INTO `omeka_schema_migrations` (`version`) VALUES
('20100401000000'),
('20100810120000'),
('20110113000000');

-- --------------------------------------------------------

--
-- Table structure for table `omeka_taggings`
--

CREATE TABLE IF NOT EXISTS `omeka_taggings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `relation_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`relation_id`,`tag_id`,`entity_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_taggings`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_tags`
--

CREATE TABLE IF NOT EXISTS `omeka_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_tags`
--


-- --------------------------------------------------------

--
-- Table structure for table `omeka_users`
--

CREATE TABLE IF NOT EXISTS `omeka_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `salt` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `role` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `entity_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `active_idx` (`active`),
  KEY `entity_id` (`entity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `omeka_users`
--

INSERT INTO `omeka_users` (`id`, `username`, `password`, `salt`, `active`, `role`, `entity_id`) VALUES
(1, 'admin', '', '', 1, 'super', 1);

-- --------------------------------------------------------

--
-- Table structure for table `omeka_users_activations`
--

CREATE TABLE IF NOT EXISTS `omeka_users_activations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `omeka_users_activations`
--

