<?php
/*
---------------------------------------------------------------------------
admin/locations.php for SALAM Frontend

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/
require("../../library/frontend.php");
require("functions.php");

if (isset($_GET['action']))
	$action = check_xss($_GET['action']);
else
	$action = 'show_locations';
	
switch ($action) {
	case 'add':
		page_start("Add Location", TRUE);
		if (isset($_POST['name'])) {
			$name = check_xss($_POST['name']);
			run_query("INSERT INTO locations (name) VALUES ('$name')");
			echo '<h3>', $name, ' Added Successfully</h3><a href="locations.php">Back to Locations</a> | <a href="locations.php?action=add">Add Another Location</a>';
		}
		else
			add_location_form();
		page_end();
		break;
	case 'edit':
		page_start("Edit Location", TRUE);
		if (isset($_POST['id'])) {
			$id = check_xss($_POST['id']);
			$name = check_xss($_POST['name']);
			run_query("UPDATE locations SET name ='$name' WHERE id = '$id'");
			echo '<h3>', $name, ' Saved Successfully</h3><a href="locations.php">Back to Locations</a>';
		}
		elseif (isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			edit_location_form($id);
		}
		page_end();
		break;
	case 'confirm':
		page_start("Delete Location", TRUE);
		if (isset($_GET['name']) && isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			$name = check_xss($_GET['name']);
			echo '<h3>Are you sure you want to delete ', $name, ', all associated hosts will need to be manually changed to a new Location?</h3>
			<a href="locations.php?action=delete&name=', $name, '&id=', $id, '">Confirm</a> | <a href="locations.php">Cancel</a>';
		}
		else
			echo 'ERROR';
		page_end();
		break;
	case 'delete':
		page_start("Delete Location", TRUE);
		if (isset($_GET['name']) && isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			$name = check_xss($_GET['name']);
			$result = run_query("DELETE FROM locations WHERE id = '$id' LIMIT 1");
				if ($result)
					echo '<h3>', $name, ' Deleted Successfully</h3><a href="locations.php">Back to Locations</a>';
				else
					echo '<h3>Error Deleting ', $name, '</h3><a href="locations.php">Back to Locations</a>';
		}
		else
			echo 'ERROR';
		page_end();
		break;
	default:
		page_start("Locations", TRUE);
		$result = run_query("SELECT id, name FROM locations ORDER BY name ASC");
		if (mysql_num_rows($result) != NULL) {
			echo '<table width="500px"><tr><th>Name:</th><th width="70px">Options</th></tr>';
			while(list($id, $name) = mysql_fetch_array($result))	{
				echo '<tr><td>', $name, '</td><td><a href="locations.php?action=edit&id=', $id, '">Edit</a> / <a href="locations.php?action=confirm&id=', $id, '&name=', $name, '">Delete</a></td></tr>';
			}
			echo '</table><br />&nbsp;';
		}
		else
			echo 'No Locations in Database, <a href="locations.php?action=add">Add a Location</a>';
		echo '<div class="pagemenu"><h3>Options:</h3><a href="locations.php?action=add">Add a Location</a></div>';
		page_end();
		break;
}
?>