<?php
/*
---------------------------------------------------------------------------
admin/triggers.php for SALAM Frontend

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/
require("../../library/frontend.php");
require("functions.php");

if (isset($_GET['action']))
	$action = check_xss($_GET['action']);
else
	$action = 'show_triggers';
	
switch ($action) {
	case 'add':
		page_start("Add Trigger", TRUE);
		if (isset($_POST['name'])) {
			$name = check_xss($_POST['name']);
			$check_id = check_xss($_POST['check_id']);
			$args = $_POST['args'];
			$frequency = check_xss($_POST['frequency']);
			if ($_POST['send_warning'] == 1)
				$send_warning = 1;
			else
				$send_warning = 0;
			if ($_POST['send_critical'] == 1)
				$send_critical = 1;
			else
				$send_critical = 0;
			$arguments = '';
			foreach ($args as $key => $value) {
				if (is_array($value) && $value[0] != '')
					$arguments .= ' -' . $key . ' ' . $value[0] . ',' . $value[1];
				elseif ($value != '' && !is_array($value))
					$arguments .= ' -' . $key . ' ' . $value;
			}
			$arguments .= ' ' . check_xss($_POST['add_args']);
			run_query("INSERT INTO triggers (name, check_id, arguments, frequency, send_warning_email, send_critical_email) VALUES ('$name', '$check_id', '$arguments', '$frequency', '$send_warning', '$send_critical')");
			echo '<h3>', $name, ' Added Successfully</h3><a href="triggers.php">Back to Triggers</a> | <a href="triggers.php?action=add">Add Another Trigger</a>';
		}
		elseif (isset($_POST['check_id'])) {
			$check_id = check_xss($_POST['check_id']);
			add_trigger_page2($check_id);
		}
		else
			add_trigger_page1();
		page_end();
		break;
	case 'edit':
		page_start("Edit Trigger", TRUE);
		if (isset($_POST['id'])) {
			$id = check_xss($_POST['id']);
			$name = check_xss($_POST['name']);
			$frequency = check_xss($_POST['frequency']);
			if ($_POST['send_warning'] == 1)
				$send_warning = 1;
			else
				$send_warning = 0;
			if ($_POST['send_critical'] == 1)
				$send_critical = 1;
			else
				$send_critical = 0;
			$args = $_POST['args'];
			$arguments = '';
			foreach ($args as $key => $value) {
				if (is_array($value) && $value[0] != '')
					$arguments .= ' -' . $key . ' ' . $value[0] . ',' . $value[1];
				elseif ($value != '' && !is_array($value))
					$arguments .= ' -' . $key . ' ' . $value;
			}
			$arguments .= ' ' . check_xss($_POST['add_args']);
			run_query("UPDATE triggers SET name = '$name', arguments = '$arguments', frequency = '$frequency', send_warning_email = '$send_warning', send_critical_email = '$send_critical' WHERE id = '$id'");
			echo '<h3>', $name, ' Saved Successfully</h3><a href="triggers.php">Back to Triggers</a>';
		}
		elseif (isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			edit_trigger($id);
		}
		page_end();
		break;
	case 'confirm':
		page_start("Delete Trigger", TRUE);
		if (isset($_GET['name']) && isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			$name = check_xss($_GET['name']);
			echo '<h3>Are you sure you want to delete ', $name, ', and all of it\'s data?</h3>
			<a href="triggers.php?action=delete&name=', $name, '&id=', $id, '">Confirm</a> | <a href="triggers.php">Cancel</a>';
		}
		else
			echo 'ERROR';
		page_end();
		break;
	case 'delete':
		page_start("Delete Trigger", TRUE);
		if (isset($_GET['name']) && isset($_GET['id'])) {
			$id = check_xss($_GET['id']);
			$name = check_xss($_GET['name']);
			$result = run_query("DELETE FROM triggers WHERE id = '$id' LIMIT 1");
			if ($result)
				$result = run_query("DELETE FROM hosts_triggers WHERE trigger_id = '$id'");
			if ($result)
				$result = run_query("DELETE FROM trigger_data WHERE trigger_id = '$id'");
			if ($result)
				$result = run_query("DELETE FROM alerts WHERE trigger_id = '$id'");
			if ($result)
				echo '<h3>', $name, ' Deleted Successfully</h3><a href="triggers.php">Back to Triggers</a>';
			else
				echo '<h3>Error Deleting ', $name, '</h3><a href="triggers.php">Back to Triggers</a>';
		}
		else
			echo 'ERROR';
		page_end();
		break;
	default:
		page_start("Triggers", TRUE);
		$category_result = run_query("SELECT id, name FROM check_categories ORDER BY id ASC");
		if (mysql_num_rows($category_result) != NULL) {
			echo '<table>';
			while(list($cat_id, $cat_name) = mysql_fetch_array($category_result)) {
				$result = run_query("SELECT triggers.id, triggers.name, checks.name, triggers.arguments, triggers.frequency, triggers.send_warning_email, triggers.send_critical_email FROM triggers, checks WHERE triggers.check_id = checks.id AND checks.category_id = $cat_id ORDER BY triggers.name ASC");
				if (mysql_num_rows($result) != NULL) {
					echo '<tr><th colspan=7>', $cat_name, '</th></tr>
					<tr><th>Name:</th><th>Check:</th><th>Arguments:</th><th>Frequency:</th><th>Send Warning Email</th><th>Send Critical Email</th><th>Options</th></tr>';
					while(list($id, $name, $check, $arguments, $frequency, $send_warning, $send_critical) = mysql_fetch_array($result))	{
						echo '<tr><td>', $name, '</td><td>', $check, '</td><td>', $arguments, '</td><td>', $frequency, ' Min.</td><td>', yes_no($send_warning), '</td><td>', yes_no($send_critical), '</td><td><a href="triggers.php?action=edit&id=', $id, '">Edit</a> / <a href="triggers.php?action=confirm&id=', $id, '&name=', $name, '">Delete</a></td></tr>';
					}
				}
			}
			echo '</table><br />&nbsp;';
		}
		else
			echo 'No Check Categories in Database';
		echo '<div class="pagemenu"><h3>Options:</h3><a href="triggers.php?action=add">Add a Trigger</a></div>';
		page_end();
		break;
}
?>