<?php
/*
---------------------------------------------------------------------------
alerts/history.php for SALAM Frontend

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/
require("../../library/frontend.php");
$rows_per_page = 30;
$page_num = 1;
if (isset($_GET['page']))
	$page_num = check_xss($_GET['page']);
$offset = ($page_num - 1) * $rows_per_page;

page_start("Alert History");
$result = run_query("SELECT hosts.name, triggers.name, alerts.type, alerts.current_info, alerts.current_data, alerts.start_time, alerts.last_check FROM hosts, triggers, alerts WHERE alerts.active = 0 AND alerts.host_id = hosts.id AND alerts.trigger_id = triggers.id ORDER BY alerts.last_check DESC LIMIT $offset, $rows_per_page");
if (mysql_num_rows($result) != NULL) {
	echo '<table class="alerts"><tr><th>Host:</th><th>Trigger:</th><th>State:</th><th>Start Time:</th><th>End Time:</th><th>Info:</th><th>Data:</th></tr>';
	while(list($host_name, $trigger_name, $alert_type, $current_info, $current_data, $start_time, $last_check) = mysql_fetch_array($result))	{
		switch ($alert_type) {
		case 0:
			$alert_type = "OK";
			break;
		case 1:
			$alert_type = "Warning";
			break;
		case 2:
			$alert_type = "Critical";
			break;
		default:
			$alert_type = "ERROR";
			break;
		}
		echo '<tr><td>', $host_name, '</td><td>', $trigger_name, '</td><td class="', $alert_type, '">', $alert_type, '</td><td>', date("D M j G:i:s T Y", $start_time), '</td><td>', date("D M j G:i:s T Y", $last_check), '</td><td>', $current_info, '</td><td>', $current_data, '</td></tr>';
	}
	echo '</table>';
	$result = run_query("SELECT COUNT(id) AS numrows FROM alerts WHERE active = 0");
	$numrows = mysql_fetch_array($result);
	$maxpage = ceil($numrows[0]/$rows_per_page);
	if ($page_num == 1)
		echo '[First] | [Previous] ';
	else
		echo '<a href="history.php?page=1">[First]</a> | <a href="history.php?page=', $page_num - 1, '">[Previous]</a> | ';
	echo '&nbsp;&nbsp;&nbsp;<strong>Page ', $page_num, ' of ', $maxpage, '</strong>&nbsp;&nbsp;&nbsp; ';
	if ($page_num == $maxpage)
		echo '[Next] | [Last]';
	else
		echo '<a href="history.php?page=', $page_num + 1, '">[Next]</a> | <a href="history.php?page=', $maxpage, '">[Last]</a>';	
}
else
	echo '<h3>No Past Alerts</h3>';
page_end();
?>