<?php
/*
---------------------------------------------------------------------------
status/host.php for SALAM Frontend

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/
require("../../library/frontend.php");

if (isset($_GET['id'])) {
	$host_id = check_xss($_GET['id']);
	$host_result = run_query("SELECT name FROM hosts WHERE id = '$host_id' LIMIT 1");
	if (mysql_num_rows($host_result) != NULL) {
		list($host_name) = mysql_fetch_array($host_result);
		$avg_time_result = run_query("SELECT AVG(uptime), AVG(warningtime), AVG(criticaltime) FROM hosts_triggers WHERE host_id = '$host_id' LIMIT 1");
		if (mysql_num_rows($avg_time_result) != NULL) {
			list($avg_uptime, $avg_warning, $avg_critical) = mysql_fetch_array($avg_time_result);
			$total = $avg_uptime + $avg_warning + $avg_critical;
			$up_percent = $avg_uptime/$total;
			$warning_percent = $avg_warning/$total;
			$critical_percent = $avg_critical/$total;
			page_start($host_name . ' Detail');
			echo '<h3>Average Uptime</h3>
			<table style="float:left">
			<tr><th>Uptime:</th></tr>
			<tr><td class="OK">', convert_seconds($avg_uptime), ' | ', number_format(@($up_percent * 100), 2), '%</td></tr>
			<tr><th>Warning:</th></tr>
			<tr><td class="Warning">', convert_seconds($avg_warning), ' | ', number_format(@($warning_percent * 100), 2), '%</td></tr>
			<tr><th>Critical:</th></tr>
			<tr><td class="Critical">', convert_seconds($avg_critical), ' | ', number_format(@($critical_percent * 100), 2), '%</td></tr>
			</table>
			<div id="pie_chart"><img src="pie_chart.php?ok=', round($up_percent,3), '&warning=', round($warning_percent,3), '&critical=', round($critical_percent,3), '" /></div>';
		}
		$detail_result = run_query("SELECT hosts_triggers.id, hosts_triggers.last_check, hosts_triggers.current_state, hosts_triggers.current_info, hosts_triggers.current_data, hosts_triggers.uptime, hosts_triggers.warningtime, hosts_triggers.criticaltime, triggers.name FROM hosts_triggers, triggers WHERE hosts_triggers.host_id = '$host_id' AND hosts_triggers.trigger_id = triggers.id ORDER BY triggers.name ASC");
		if (mysql_num_rows($detail_result) != NULL) {
			echo '<h3>Triggers</h3><table>';
			echo '<tr><th>Trigger:</th><th>State:</th><th>Last Check:</th><th>Info:</th><th>Data:</th><th>Uptime:</th><th>Warning:</th><th>Critical:</th></tr>';
			while(list($host_trigger_id, $last_check, $state, $info, $data, $uptime, $warning, $critical, $trigger_name) = mysql_fetch_array($detail_result))	{
				echo '<tr class="', return_state($state), '"><td><a href="trigger.php?id=', $host_trigger_id, '">', $trigger_name, '</a></td><td>', return_state($state), '</td><td>', date("D M j G:i:s T Y", $last_check), '</td><td>', $info, '</td><td>', $data, '</td><td class="OK">', convert_seconds($uptime), ' | ', number_format(@($uptime/($uptime + $warning + $critical) * 100), 2), '%</td><td class="Warning">', convert_seconds($warning), ' | ', number_format(@($warning/($uptime + $warning + $critical) * 100), 2), '%</td><td class="Critical">', convert_seconds($critical), ' | ', number_format(@($critical/($uptime + $warning + $critical) * 100), 2), '%</td></tr>';
			}
		}
		echo '</table>';
		echo '<h3>Past Alerts</h3>';
		$result = run_query("SELECT triggers.name, alerts.type, alerts.current_info, alerts.current_data, alerts.start_time, alerts.last_check FROM triggers, alerts WHERE alerts.host_id = $host_id AND alerts.trigger_id = triggers.id ORDER BY alerts.last_check DESC LIMIT 10");
		if (mysql_num_rows($result) != NULL) {
			echo '<table class="alerts"><tr><th>Trigger:</th><th>State:</th><th>Start Time:</th><th>End Time:</th><th>Info:</th><th>Data:</th></tr>';
			while(list($trigger_name, $alert_type, $current_info, $current_data, $start_time, $last_check) = mysql_fetch_array($result))	{
				switch ($alert_type) {
				case 0:
					$alert_type = "OK";
					break;
				case 1:
					$alert_type = "Warning";
					break;
				case 2:
					$alert_type = "Critical";
					break;
				default:
					$alert_type = "ERROR";
					break;
				}
				echo '<tr><td>', $trigger_name, '</td><td class="', $alert_type, '">', $alert_type, '</td><td>', date("D M j G:i:s T Y", $start_time), '</td><td>', date("D M j G:i:s T Y", $last_check), '</td><td>', $current_info, '</td><td>', $current_data, '</td></tr>';
			}
			echo '</table>';
		}
		else
			echo '<h4>No Past Alerts</h4>';
	}
}
page_end();
?>