<?php
/*
---------------------------------------------------------------------------
status/pie_chart.php for SALAM Frontend

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/
require_once("../../library/frontend.php");

if (isset($_GET['ok'])) {
	$ok = check_xss($_GET['ok']);
	$warning = check_xss($_GET['warning']);
	$critical = check_xss($_GET['critical']);
	
	$offset = 45;
	
	if (is_numeric($critical) && $critical >= 0.005)
		$critical = array($offset, (360 * $critical) + $offset);
	else
		$critical = array(0, $offset);
	if (is_numeric($warning) && $warning >= 0.005)
		$warning = array($critical[1], (360*$warning) + $critical[1]);
	else
		$warning = array(0, $critical[1]);
	if (is_numeric($ok) && $ok >= 0.005) 
		$ok = array($warning[1], 360+$offset);
	else
		$ok = 0;
	
	$imagewidth = 600;
	$piewidth = $imagewidth;
	$pieheight = $imagewidth / 2;
	$pieheight3d = $pieheight * .2;

	$imageheight = $pieheight + $pieheight3d;
	$center_x = $imagewidth / 2;
	$center_y = ($imageheight - $pieheight3d) / 2;

	$image = imagecreatetruecolor($imagewidth, $imageheight);
	$outimage = imagecreatetruecolor($imagewidth/3, $imageheight/3);

	$white = imagecolorallocate($image, 255,255,255);
	$green    = imagecolorallocate($image, 0,128,0);
	$yellow     = imagecolorallocate($image, 255,255,0);
	$red = imagecolorallocate($image, 255,0,0);
	$darkgreen     = imagecolorallocate($image, 0,80,0);
	$darkyellow = imagecolorallocate($image, 150,150,0);
	$darkred  = imagecolorallocate($image, 150,0,0);

	imagefill($image, 0, 0, $white);

	for ($i = $center_y + $pieheight3d; $i >= $center_y; $i--) {
		if ($critical[0] != 0)
			imagefilledarc($image, $center_x, $i, $piewidth, $pieheight, $critical[0], $critical[1], $darkred, IMG_ARC_NOFILL);
		if ($warning[0] != 0)
			imagefilledarc($image, $center_x, $i, $piewidth, $pieheight, $warning[0], $warning[1], $darkyellow, IMG_ARC_NOFILL);
		if ($ok != 0)
			imagefilledarc($image, $center_x, $i, $piewidth, $pieheight, $ok[0], $ok[1], $darkgreen, IMG_ARC_NOFILL);
	}

	if ($critical[0] != 0)
		imagefilledarc($image, $center_x, $center_y, $piewidth, $pieheight, $critical[0], $critical[1], $red, IMG_ARC_PIE);
	if ($warning[0] != 0)
		imagefilledarc($image, $center_x, $center_y, $piewidth, $pieheight, $warning[0], $warning[1], $yellow, IMG_ARC_PIE);
	if ($ok != 0)
		imagefilledarc($image, $center_x, $center_y, $piewidth, $pieheight, $ok[0], $ok[1], $green, IMG_ARC_PIE);

	imagecopyresampled($outimage,$image,0,0,0,0,$imagewidth/3,$imageheight/3,$imagewidth,$imageheight);

	/*print_r($critical);
	print_r($warning);
	print_r($ok);*/
	
	header('Content-type: image/png');
	imagepng($outimage);
	imagedestroy($outimage);
	imagedestroy($image);
	
}
?>