<?php
/*
---------------------------------------------------------------------------
frontend.php for SALAM

Copyright 2009, 2010 Jacob McEntire

    This file is part of SALAM.

    SALAM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SALAM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SALAM.  If not, see <http://www.gnu.org/licenses/>.
---------------------------------------------------------------------------
*/

session_start();

//Get User Settings
require('settings.php');
$frequency = array (1,3,5,15,30,60);
//Set Timezone
date_default_timezone_set($time_zone);

//Database Configuration and Function to Connect to DB:
function opendb(){
  global $conn, $dbhost, $dbuser, $dbpass, $dbname;
  $conn = mysql_connect($dbhost, $dbuser, $dbpass) or die ('Error connecting to mysql');
  mysql_select_db($dbname);
}

//Close the DB
function closedb(){
  global $conn;
  mysql_close($conn);
}

//Run a query on the DB
function run_query($query) {
    opendb();
    $result = mysql_query($query) or die('Error, query failed ' . mysql_error());
    closedb();
    return $result;
}

function run_query_return_id($query) {
    opendb();
    $result = mysql_query($query) or die('Error, query failed ' . mysql_error());
	$id = mysql_insert_id();
    closedb();
    return $id;
}

function check_xss($input) {
	$input = utf8_decode($input);
	$input = htmlentities($input, ENT_QUOTES);
	if(!get_magic_quotes_gpc())
		$input  = addslashes($input);
	return $input;
}

function page_start($pagename, $admin = FALSE) {
echo '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>', $pagename, ' - SALAM</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="icon" type="image/png" href="images/icon.png" />
<link rel="shortcut icon" href="/favicon.ico">
<link rel="stylesheet" href="../style.css" />';
if (function_exists('jscripthead'))
	jscripthead();
echo '
</head>
<body';
if ($autorefresh == TRUE)
	echo ' onload="timedCount()"';
echo ' style="background-color:gray;">
<div class="header">
<div class="logo">
<h1>SALAM</h1>
</div>
<div class="menu">';
if ($admin == TRUE)
	echo '--ADMINISTRATION-- <a href="../admin/hosts.php">Hosts</a> | <a href="../admin/locations.php">Locations</a> | <a href="../admin/groups.php">Groups</a> | <a href="../admin/triggers.php">Triggers</a> | <a href="../admin/editsettings.php">Settings</a> | <a href="../admin/changepassword.php">Change Password</a> --ADMINISTRATION--<a href="../status/overview.php" class="admin_link">Exit Administration Mode</a>';
else
	echo '<a href="../status/overview.php">Status Overview</a> | <a href="../status/detail.php">Status Detail</a> | <a href="../alerts/active.php">Active Alerts</a> | <a href="../alerts/history.php">Alert History</a> | <a href="../status/queue.php">Queue</a><a href="../admin/hosts.php" class="admin_link">Enter Administration Mode</a>';
echo '
</div>
</div>
<div class="frame">
<div class="body">
<h2>', $pagename, '</h2>';
}

function page_end($autorefresh = FALSE) {
	global $refresh_frequency;
	if ($autorefresh != FALSE) {
		$refresh_frequency = $refresh_frequency * 1000;
		echo '
			<script type="text/javascript">
			var url = "', $autorefresh, '";
			function getData(){
				if (window.XMLHttpRequest){
				  xmlhttp=new XMLHttpRequest();
				}
				else{
				  xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
				}
				xmlhttp.open("GET",url,false);
				xmlhttp.send(null);
				document.getElementById("data").innerHTML=xmlhttp.responseText;
				setTimeout("getData()",', $refresh_frequency, ');
			}
			window.onload = getData();
			</script>';
	}
	echo '
	</div>
	</div>
	<div class="footer">
	SALAM v 0.1 RC1
	</div>

	</body>
	</html>';
}

function return_state($value) {
	switch ($value) {
		case 0:
			return 'OK';
			break;
		case 1:
			return 'Warning';
			break;
		case 2:
			return 'Critical';
			break;
		case 99:
			return 'Averaged';
			break;
		default:
			return 'ERROR';
			break;
	}
}

function convert_seconds($value) {
$ret = '';
$years = intval($value / 31556926);
if ($years > 1)
	$ret .= $years . ' Years ';
else if ($years == 1)
	$ret .= $years . ' Year ';
$days = intval(($value % 31556926) / 86400);
if ($days > 1)
	$ret .= $days . ' Days ';
else if ($days == 1)
	$ret .= $days . ' Day ';
$hours = intval(($value % 86400) / 3600);
if ($hours > 1)
	$ret .= $hours . ' Hours ';
else if ($hours == 1)
	$ret .= $hours . ' Hour ';
$minutes = intval(($value % 3600) / 60);
if ($minutes > 1)
	$ret .= $minutes . ' Minutes ';
else if ($minutes == 1)
	$ret .= $minutes . ' Minute ';
if ($ret == '')
	$ret = 'N/A';
return $ret;
}

?>