CREATE TABLE IF NOT EXISTS `alerts` (
  `id` int(11) NOT NULL auto_increment,
  `host_id` int(11) NOT NULL,
  `trigger_id` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `type` int(11) NOT NULL,
  `current_info` varchar(120) NOT NULL,
  `current_data` varchar(120) NOT NULL,
  `start_time` int(11) NOT NULL,
  `last_check` int(11) NOT NULL,
  `email_sent` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `checks`
--

CREATE TABLE IF NOT EXISTS `checks` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  `file_name` varchar(120) NOT NULL,
  `host_arg` varchar(10) NOT NULL,
  `available_args` varchar(120) NOT NULL,
  `args_name` varchar(300) NOT NULL,
  `args_type` varchar(300) NOT NULL,
  `args_default` varchar(300) NOT NULL,
  `manpage` varchar(300) NOT NULL,
  `data_names` varchar(60) NOT NULL,
  `data_types` varchar(60) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `checks`
--

INSERT INTO `checks` (`id`, `name`, `file_name`, `host_arg`, `available_args`, `args_name`, `args_type`, `args_default`, `manpage`, `data_names`, `data_types`, `category_id`) VALUES
(1, 'Check Ping', 'plugins/check_icmp', '-H', 'w|c|n', 'Warning Threshold|Critical Threshold|Number of Pings to send', 'ms,%|ms,%|int', '500,40%|5000,80%|5', 'http://nagiosplugins.org/man/check_icmp', 'Response Time|Packet Loss', 'ms|%', 1),
(2, 'Check TCP Port', 'plugins/check_tcp', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '', 'http://nagiosplugins.org/man/check_tcp', 'Response Time|Size', 'sec|Bytes', 2),
(3, 'Check UDP Port', 'plugins/check_udp', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '', 'http://nagiosplugins.org/man/check_udp', 'Response Time|Size', 'sec|Bytes', 2),
(4, 'Check FTP', 'plugins/check_ftp', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '21|5|10', 'http://nagiosplugins.org/man/check_ftp', 'Response Time', 'sec', 2),
(5, 'Check HTTP', 'plugins/check_http', '-H', 'w|c|S', 'Warning Threshold|Critical Threshold|Use SSL(Port: 443)', 'seconds|seconds|checkbox', '5|10', 'http://nagiosplugins.org/man/check_http', 'Response Time|Size', 'sec|Bytes', 2),
(6, 'Check SMTP', 'plugins/check_smtp', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '25|5|10', 'http://nagiosplugins.org/man/check_smtp', 'Response Time|Size', 'sec|Bytes', 2),
(7, 'Check POP3', 'plugins/check_pop', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '110|5|10', 'http://nagiosplugins.org/man/check_pop', 'Response Time|Size', 'sec|Bytes', 2),
(8, 'Check IMAP', 'plugins/check_imap', '-H', 'p|w|c', 'Port Number|Warning Threshold|Critical Threshold', 'int|seconds|seconds', '143|5|10', 'http://nagiosplugins.org/man/check_imap', 'Response Time|Size', 'sec|Bytes', 2),
(9, 'Check DNS', 'plugins/check_dig', '-H', 'l|p|w|c', 'Name to Lookup|Port(Default: 53)|Warning Threshold|Critical Threshold', 'string|int|seconds|seconds', 'google.com|53|5|10', 'http://nagiosplugins.org/man/check_dig', 'Response Time', 'sec', 2),
(10, 'Check NT Service', 'plugins/salam_check_nt_service', '-H', 'S', 'Service', 'string', '', '', 'State', '', 3),
(11, 'Check NT Memory', 'plugins/salam_check_nt_memory', '-H', 'W|C', 'Warning Threshold|Critical Threshold', 'MB,%|MB,%', '256,20|64,5', '', 'Free|Used(%)|Total', 'MB|%|MB', 3),
(12, 'Check NT DiskSpace', 'plugins/salam_check_nt_diskspace', '-H', 'D|W|C', 'Disk|Warning Threshold|Critical Threshold', 'string|GB,%|GB,%', 'C:|5,15|1,5', '', 'Free(GB)|Free(%)|Total Size(GB)', 'GB|%|GB', 3);

-- --------------------------------------------------------

--
-- Table structure for table `check_categories`
--

CREATE TABLE IF NOT EXISTS `check_categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `check_categories`
--

INSERT INTO `check_categories` (`id`, `name`) VALUES
(1, 'General Network'),
(2, 'Network Services'),
(3, 'Microsoft WMI');

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE IF NOT EXISTS `groups` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` (`id`, `name`) VALUES
(1, 'Servers');

-- --------------------------------------------------------

--
-- Table structure for table `hosts`
--

CREATE TABLE IF NOT EXISTS `hosts` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  `dns_name_or_ip` varchar(60) NOT NULL,
  `group_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `enable_monitoring` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `hosts`
--

INSERT INTO `hosts` (`id`, `name`, `dns_name_or_ip`, `group_id`, `location_id`, `enable_monitoring`) VALUES
(1, 'SALAM Server', 'localhost', 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `hosts_triggers`
--

CREATE TABLE IF NOT EXISTS `hosts_triggers` (
  `id` int(11) NOT NULL auto_increment,
  `host_id` int(11) NOT NULL default '0',
  `trigger_id` int(11) NOT NULL default '0',
  `uptime` int(11) NOT NULL default '0',
  `warningtime` int(11) NOT NULL default '0',
  `criticaltime` int(11) NOT NULL default '0',
  `last_check` int(11) NOT NULL default '0',
  `current_state` int(11) NOT NULL default '0',
  `current_info` varchar(120) NOT NULL,
  `current_data` varchar(120) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=61 ;

--
-- Dumping data for table `hosts_triggers`
--

INSERT INTO `hosts_triggers` (`id`, `host_id`, `trigger_id`) VALUES
(1, 1, 1),
(2, 1, 8),
(3, 1, 16);

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`id`, `name`) VALUES
(1, 'Default Location');

-- --------------------------------------------------------

--
-- Table structure for table `run_times`
--

CREATE TABLE IF NOT EXISTS `run_times` (
  `frequency` int(11) NOT NULL,
  `last_run` int(11) NOT NULL,
  PRIMARY KEY  (`frequency`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `triggers`
--

CREATE TABLE IF NOT EXISTS `triggers` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  `check_id` int(11) NOT NULL,
  `arguments` varchar(120) NOT NULL,
  `frequency` int(11) NOT NULL,
  `send_warning_email` tinyint(1) NOT NULL,
  `send_critical_email` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `triggers`
--

INSERT INTO `triggers` (`id`, `name`, `check_id`, `arguments`, `frequency`, `send_warning_email`, `send_critical_email`) VALUES
(1, 'Ping over LAN', 1, ' -w 50,25% -c 100,50% ', 1, 0, 1),
(2, 'Ping over WAN', 1, ' -w 500,50% -c 1000,75%', 3, 0, 1),
(3, 'Ping over PTP', 1, ' -w 100,25% -c 500,50% ', 1, 0, 1),
(4, 'Ping over VPN', 1, ' -w 500,50% -c 1000,75% ', 3, 0, 1),
(5, 'SMTP', 6, '', 5, 0, 1),
(6, 'POP3', 7, '', 5, 0, 1),
(7, 'IMAP', 8, '', 5, 0, 1),
(8, 'HTTP', 5, '-w 5 -c 10', 5, 0, 1),
(9, 'HTTPS', 5, '-S -w 5 -c 10', 5, 0, 1),
(10, 'DNS', 9, '-l www.google.com', 5, 0, 1),
(11, 'FTP', 4, '', 5, 0, 1),
(12, 'LDAP', 2, '-p 389', 5, 0, 1),
(13, 'MS RPC', 2, '-p 135', 5, 0, 1),
(14, 'MS Active Directory', 2, '-p 445', 5, 0, 1),
(15, 'NETBIOS', 2, '-p 139', 5, 0, 1),
(16, 'SSH', 2, '-p 22', 5, 0, 1),
(17, 'Telnet', 2, '-p 23', 5, 0, 1),
(18, 'MS RDP', 2, '-p 3389', 5, 0, 1),
(19, 'VNC', 2, ' -p 5900 ', 5, 0, 1),
(20, 'MS DNS Server', 10, ' -S DNS     ', 5, 0, 1),
(21, 'MS Exchange Information Store', 10, ' -S MSExchangeIS   ', 5, 0, 1),
(22, 'MS DHCP Server', 10, ' -S DHCPServer   ', 5, 0, 1),
(23, 'MS File/Print Server', 10, ' -S lanmanserver   ', 5, 0, 1),
(24, 'MS DFS', 10, ' -S dfs   ', 5, 0, 1),
(25, 'Free DiskSpace C:', 12, ' -D C: -W 5,15% -C 1,5% ', 60, 0, 1),
(26, 'Free Memory', 11, ' -W 256,20% -C 64,5% ', 30, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `trigger_data`
--

CREATE TABLE IF NOT EXISTS `trigger_data` (
  `id` int(11) NOT NULL auto_increment,
  `host_id` int(11) NOT NULL,
  `trigger_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `state` tinyint(1) NOT NULL default '0',
  `data` varchar(120) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;